/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors;

import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.jboss.tools.common.model.XModelObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLModelObjectFinder {
    public XModelObject findModelObject(IndexedRegion region, XModelObject root) {
        if (root == null) {
            return null;
        }
        if (!(region instanceof Node)) {
            return null;
        }
        Node node = (Node)region;
        while (node != null && !(node instanceof Element)) {
            node = node.getParentNode();
        }
        if (node == null) {
            return null;
        }
        Chain c = new Chain();
        c.name = node.getNodeName();
        while (node != null) {
            Node sibling = node;
            while (sibling != null) {
                if (!((sibling = sibling.getPreviousSibling()) instanceof Element) || !c.name.equals(sibling.getNodeName())) continue;
                ++c.index;
            }
            if (!((node = node.getParentNode()) instanceof Element)) break;
            Chain c1 = new Chain();
            c1.name = node.getNodeName();
            c1.child = c;
            c = c1;
        }
        return this.findModelObject(c, root);
    }

    private XModelObject findModelObject(Chain chain, XModelObject o) {
        XModelObject res;
        if (chain == null) {
            return o;
        }
        String n = o.getModelEntity().getXMLSubPath();
        if (n.equals(chain.name)) {
            return this.findModelObject(chain.child, o);
        }
        String childEntity = this.getChildEntity(chain.name, o);
        if (childEntity != null) {
            XModelObject[] cs = o.getChildren();
            if (cs.length <= chain.index) {
                XModelObject c = this.findModelObject(chain.child, o);
                if (c != null) {
                    return c;
                }
                return o;
            }
            int index = -1;
            int i = 0;
            while (i < cs.length) {
                if (chain.name != null && chain.name.equals(cs[i].getModelEntity().getXMLSubPath()) && ++index == chain.index) {
                    return this.findModelObject(chain.child, cs[i]);
                }
                ++i;
            }
            XModelObject c = this.findModelObject(chain.child, o);
            if (c != null) {
                return c;
            }
            return o;
        }
        XModelObject[] cs = o.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (cs[i].getModelEntity().getXMLSubPath().length() <= 0 && (res = this.findModelObject(chain, cs[i])) != cs[i]) {
                return res;
            }
            ++i;
        }
        XModelObject x = o.getChildByPath(String.valueOf(chain.name) + (chain.index == 0 ? "" : Integer.valueOf(chain.index)));
        if (x != null) {
            res = this.findModelObject(chain.child, x);
            if (res != null) {
                return res;
            }
            return x;
        }
        return o;
    }

    private String getChildEntity(String nodename, XModelObject o) {
        return o.getModelEntity().getChildByXML(nodename);
    }

    class Chain {
        Chain child;
        String name;
        int index;

        Chain() {
        }
    }
}

