/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.dependencies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.model.Exclusion;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.packaging.PackagingType;

public class MavenDependencyAdapter
extends org.apache.maven.model.Dependency
implements Dependency {
    private static final long serialVersionUID = -518791785675970540L;

    public MavenDependencyAdapter(org.apache.maven.model.Dependency dep) {
        if (dep == null) {
            throw new IllegalArgumentException("Dependency must not be null.");
        }
        org.apache.maven.model.Dependency clone = dep.clone();
        this.setArtifactId(clone.getArtifactId());
        this.setGroupId(clone.getGroupId());
        this.setClassifier("".equals(clone.getClassifier()) ? null : clone.getClassifier());
        this.setExclusions(clone.getExclusions());
        this.setOptional(clone.isOptional());
        this.setScope(clone.getScope());
        this.setType(clone.getType());
        this.setVersion(clone.getVersion());
    }

    public MavenDependencyAdapter(Dependency dep) {
        if (dep == null) {
            throw new IllegalArgumentException("Dependency must not be null.");
        }
        this.setArtifactId(dep.getArtifactId());
        this.setGroupId(dep.getGroupId());
        this.setVersion(dep.getVersion());
        this.setScope(dep.getScopeType());
        this.setType(dep.getPackagingType());
        this.setClassifier(dep.getClassifier());
        for (Dependency exclusion : dep.getExcludedDependencies()) {
            Exclusion temp = new Exclusion();
            temp.setArtifactId(exclusion.getArtifactId());
            temp.setGroupId(exclusion.getGroupId());
            this.getExclusions().add(temp);
        }
    }

    public MavenDependencyAdapter(org.sonatype.aether.graph.Dependency dep) {
        if (dep == null) {
            throw new IllegalArgumentException("Dependency must not be null.");
        }
        this.setArtifactId(dep.getArtifact().getArtifactId());
        this.setGroupId(dep.getArtifact().getGroupId());
        this.setClassifier("".equals(dep.getArtifact().getClassifier()) ? null : dep.getArtifact().getClassifier());
        this.setExclusions(dep.getExclusions());
        this.setOptional(dep.isOptional());
        this.setScope(dep.getScope());
        this.setType(dep.getArtifact().getExtension());
        this.setVersion(dep.getArtifact().getVersion());
    }

    private void setExclusions(Collection<org.sonatype.aether.graph.Exclusion> exclusions) {
        ArrayList<Exclusion> result = new ArrayList<Exclusion>();
        for (org.sonatype.aether.graph.Exclusion exclusion : exclusions) {
            Exclusion temp = new Exclusion();
            temp.setArtifactId(exclusion.getArtifactId());
            temp.setGroupId(exclusion.getGroupId());
            result.add(temp);
        }
        super.setExclusions(result);
    }

    public String getScope() {
        return super.getScope() == null ? null : super.getScope().toLowerCase().trim();
    }

    public String getScopeType() {
        return this.getScope();
    }

    public ScopeType getScopeTypeEnum() {
        return ScopeType.from((String)this.getScope());
    }

    public List<Dependency> getExcludedDependencies() {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        List exclusions = this.getExclusions();
        for (Exclusion exclusion : exclusions) {
            DependencyBuilder dep = DependencyBuilder.create().setArtifactId(exclusion.getArtifactId()).setGroupId(exclusion.getGroupId());
            result.add((Dependency)dep);
        }
        return result;
    }

    public static List<Dependency> fromMavenList(List<org.apache.maven.model.Dependency> dependencies) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (org.apache.maven.model.Dependency dep : dependencies) {
            result.add(new MavenDependencyAdapter(dep));
        }
        return result;
    }

    public static List<org.apache.maven.model.Dependency> toMavenList(List<Dependency> dependencies) {
        ArrayList<org.apache.maven.model.Dependency> result = new ArrayList<org.apache.maven.model.Dependency>();
        for (Dependency dep : dependencies) {
            result.add(new MavenDependencyAdapter(dep));
        }
        return result;
    }

    public String getPackagingType() {
        return this.getType();
    }

    public PackagingType getPackagingTypeEnum() {
        return PackagingType.from((String)this.getPackagingType());
    }

    public String getType() {
        return super.getType() == null ? null : super.getType().toLowerCase().trim();
    }

    public String toString() {
        return DependencyBuilder.toString((Dependency)this);
    }

    public String toCoordinates() {
        return DependencyBuilder.toId((Dependency)this);
    }

    public static List<Dependency> fromAetherList(List<org.sonatype.aether.graph.Dependency> dependencies) {
        ArrayList<Dependency> result = new ArrayList<Dependency>();
        for (org.sonatype.aether.graph.Dependency dependency : dependencies) {
            result.add(new MavenDependencyAdapter(dependency));
        }
        return result;
    }
}

