/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.page.link;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.model.helpers.page.link.Link;
import org.jboss.tools.struts.model.helpers.page.link.LinksListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Links {
    Set<String> tags = new HashSet<String>();
    String[] tagsArray;
    Map<String, Link[]> links = new HashMap<String, Link[]>();
    ArrayList<LinksListener> listeners = new ArrayList();
    long timeStamp = 0L;

    public Set<String> getTags() {
        return this.tags;
    }

    public String[] getTagsArray() {
        return this.tagsArray;
    }

    public Link[] getLinks(String tag) {
        Link[] ls = this.links.get(tag);
        return ls != null ? ls : new Link[]{};
    }

    public void update(XModelObject object) {
        if (this.timeStamp == object.getTimeStamp()) {
            return;
        }
        this.timeStamp = object.getTimeStamp();
        HashSet<String> _tags = new HashSet<String>();
        HashMap _links = new HashMap();
        HashMap<String, Link[]> links2 = new HashMap<String, Link[]>();
        XModelObject[] cs = object.getChildren();
        int i = 0;
        while (i < cs.length) {
            String tag = cs[i].getAttributeValue("tag");
            String attr = cs[i].getAttributeValue("attribute");
            String referTo = cs[i].getAttributeValue("refer to");
            _tags.add(tag);
            HashSet<Link> s = (HashSet<Link>)_links.get(tag);
            if (s == null) {
                s = new HashSet<Link>();
                _links.put(tag, s);
            }
            Link link = new Link();
            link.setTag(tag);
            link.setAttribute(attr);
            link.setReferTo(referTo);
            s.add(link);
            ++i;
        }
        for (String tag : _tags) {
            Set s = (Set)_links.get(tag);
            if (s == null) continue;
            Link[] ls = s.toArray(new Link[0]);
            links2.put(tag, ls);
        }
        this.links = links2;
        this.tags = _tags;
        this.tagsArray = this.tags.toArray(new String[0]);
        this.fireLinksChanged();
    }

    private void fireLinksChanged() {
        LinksListener[] ls = this.listeners.toArray(new LinksListener[0]);
        int i = 0;
        while (i < ls.length) {
            ls[i].linksChanged();
            ++i;
        }
    }

    public void addLinksListener(LinksListener listener) {
        this.listeners.add(listener);
    }

    public void removeLinksListener(LinksListener listener) {
        this.listeners.remove(listener);
    }
}

