/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers.page;

import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.DeleteFileHandler;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.StrutsPreference;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.handlers.page.DeletePageUndo;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;

public class DeletePageHandler
implements StrutsConstants {
    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        String target = object.getAttributeValue("name");
        if (!object.isActive()) {
            return;
        }
        if (StrutsProcessHelper.getReferers(object.getParent(), target).size() > 0) {
            ServiceDialog d = object.getModel().getService();
            String msg = NLS.bind((String)StrutsUIMessages.PAGE_IS_REFERENCED, (Object)object.getPresentationString());
            d.showDialog(StrutsUIMessages.WARNING, msg, new String[]{StrutsUIMessages.OK}, null, 2);
        } else {
            XModelObject page = StrutsProcessStructureHelper.instance.getPhysicalPage(object);
            IFile f = this.getFile(object);
            boolean deleteFile = true;
            if (f != null) {
                deleteFile = "yes".equals(StrutsPreference.REMOVE_PAGE_AND_FILE.getValue());
                ServiceDialog d = object.getModel().getService();
                Properties xp = new Properties();
                xp.setProperty("message", String.valueOf(StrutsUIMessages.DELETE_PAGE) + object.getPresentationString() + "?");
                xp.setProperty("checkboxMessage", StrutsUIMessages.REMOVE_FILE_FROM_DISK);
                xp.put("checked", new Boolean(deleteFile));
                if (!d.openConfirm(xp)) {
                    return;
                }
                deleteFile = (Boolean)xp.get("checked");
                StrutsPreference.REMOVE_PAGE_AND_FILE.setValue(deleteFile ? "yes" : "no");
            }
            XModelObject parent = object.getParent();
            object.removeFromParent();
            XUndoManager undo = parent.getModel().getUndoManager();
            if (undo != null) {
                parent.getModel().getUndoManager().addUndoable((XUndoable)new DeletePageUndo(parent, object));
            }
            parent.setModified(true);
            if (f != null && deleteFile) {
                new DeleteFileHandler().executeHandler(page, null);
            }
        }
    }

    public IFile getFile(XModelObject object) {
        XModelObject page = StrutsProcessStructureHelper.instance.getPhysicalPage(object);
        return page instanceof FileAnyImpl ? ((FileAnyImpl)page).getFile() : null;
    }
}

