/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.loaders.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.loaders.impl.EncodedProperties;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;

public class PropertiesLoader
implements XObjectLoader {
    public static String ENT_PROPERTY = "Property";
    static String INTERNAL_SEPARATOR = "@";
    static String defaultLineSeparator = System.getProperty("line.separator");

    static {
        if (defaultLineSeparator == null) {
            defaultLineSeparator = "\r\n";
        }
    }

    public static String getEncoding(XModelObject object) {
        if (!object.isActive()) {
            String encoding = object.get("_encoding_");
            return encoding != null && encoding.length() > 0 ? encoding : "8859_1";
        }
        IFile f = PropertiesLoader.getFile(object);
        return f != null ? FileUtil.getEncoding((IFile)f) : null;
    }

    private static IFile getFile(XModelObject object) {
        Object resource = object.getAdapter(IResource.class);
        return resource instanceof IFile ? (IFile)resource : null;
    }

    @Override
    public void load(XModelObject object) {
        String encoding = PropertiesLoader.getEncoding(object);
        object.setAttributeValue("encoding", encoding);
        String body = XModelObjectLoaderUtil.getTempBody(object);
        EncodedProperties properties = new EncodedProperties();
        properties.setEncoding(encoding);
        Properties mapping = new Properties();
        try {
            ByteArrayInputStream s = new ByteArrayInputStream(body.getBytes(encoding));
            properties.load(s);
            Iterator<Object> it = properties.keySet().iterator();
            while (it.hasNext()) {
                String nm = it.next().toString();
                String sn = EncodedProperties.saveConvert(nm, true);
                mapping.put(sn, nm);
            }
        }
        catch (IOException iOException) {}
        StringTokenizer st = new StringTokenizer(body, "\n\r", true);
        StringBuilder sb = new StringBuilder();
        StringBuilder lineEnd = new StringBuilder();
        int state = 0;
        XModelObject c = null;
        while (st.hasMoreTokens()) {
            String dirtyvalue;
            String s = st.nextToken();
            if (s.equals("\r")) {
                if (lineEnd.toString().equals("\r")) {
                    if (state == 0) {
                        state = 1;
                    } else if (state == 2) {
                        state = 0;
                        c.setAttributeValue("dirtyvalue", sb.toString());
                        c.setAttributeValue("line-end", lineEnd.toString());
                        sb.setLength(0);
                        lineEnd.setLength(0);
                    }
                }
                if (state != 2) {
                    sb.append(s);
                    continue;
                }
                lineEnd.append(s);
                continue;
            }
            if (s.equals("\n")) {
                if (state != 2) {
                    sb.append(s);
                } else {
                    lineEnd.append(s);
                }
                if (state == 0) {
                    state = 1;
                    continue;
                }
                if (state != 2) continue;
                state = 0;
                c.setAttributeValue("dirtyvalue", sb.toString());
                c.setAttributeValue("line-end", lineEnd.toString());
                sb.setLength(0);
                lineEnd.setLength(0);
                continue;
            }
            lineEnd.setLength(0);
            if (state == 3) {
                if (!this.endsWithBackslash(s)) {
                    sb.append(s);
                    state = 2;
                    continue;
                }
                sb.append(s.substring(0, s.length() - 1)).append(INTERNAL_SEPARATOR);
                continue;
            }
            int i = PropertiesLoader.getSeparatorIndex(s);
            if (i < 0) {
                sb.append(s);
                state = 1;
                continue;
            }
            String dirtyName = s.substring(0, i);
            String name = dirtyName.trim();
            String visualName = mapping.getProperty(name);
            if (visualName == null || !properties.containsKey(visualName)) {
                sb.append(s);
                state = 1;
                continue;
            }
            String comments = sb.toString();
            sb.setLength(0);
            String value = properties.getProperty(visualName);
            Properties p = new Properties();
            p.setProperty("name", visualName);
            p.setProperty("dirtyname", dirtyName);
            p.setProperty("value", value);
            p.setProperty("name-value-separator", i == s.length() ? " " : "" + s.charAt(i));
            p.setProperty("comments", comments);
            p.setProperty("separator", "#");
            p.setProperty("line-end", "");
            c = object.getModel().createModelObject(ENT_PROPERTY, p);
            object.addChild(c);
            String string = dirtyvalue = i < s.length() ? s.substring(i + 1) : "";
            if (this.endsWithBackslash(s)) {
                state = 3;
                sb.append(dirtyvalue.substring(0, dirtyvalue.length() - 1)).append(INTERNAL_SEPARATOR);
                continue;
            }
            state = 2;
            sb.append(dirtyvalue);
        }
        if (state == 1 && sb.length() > 0) {
            object.set("conclusion", sb.toString());
        }
        if (state == 2) {
            c.setAttributeValue("dirtyvalue", sb.toString());
            c.setAttributeValue("line-end", lineEnd.toString());
        }
    }

    boolean endsWithBackslash(String s) {
        boolean result = false;
        int i = s.length() - 1;
        while (i >= 0) {
            if (s.charAt(i) != '\\') {
                return result;
            }
            result = !result;
            --i;
        }
        return result;
    }

    @Override
    public boolean update(XModelObject object) throws XModelException {
        String encoding = PropertiesLoader.getEncoding(object);
        XModelObject c = object.copy(0);
        if (encoding != null) {
            c.set("_encoding_", encoding);
        }
        XModelObjectLoaderUtil.setTempBody(c, XModelObjectLoaderUtil.getTempBody(object));
        this.load(c);
        this.merge(object, c);
        object.setModified(false);
        return true;
    }

    @Override
    public boolean save(XModelObject object) {
        if (!object.isModified()) {
            return true;
        }
        XModelObjectLoaderUtil.setTempBody(object, this.generateBody(object));
        object.setModified(true);
        return true;
    }

    private void appendComments(StringBuffer sb, String comments, String commentSeparator, String lineSeparator) {
        if (comments.length() == 0) {
            return;
        }
        sb.append(comments);
    }

    public String getBody(XModelObject object) {
        return this.generateBody(object);
    }

    private String generateBody(XModelObject object) {
        String lineSeparator = defaultLineSeparator;
        StringBuffer sb = new StringBuffer();
        XModelObject[] cs = object.getChildren();
        int i = 0;
        while (i < cs.length) {
            String ls = cs[i].get("line-end");
            if (ls.length() > 0 && !ls.equals("\\r\\n")) {
                lineSeparator = ls;
                break;
            }
            ++i;
        }
        i = 0;
        while (i < cs.length) {
            String name_value_separator = cs[i].getAttributeValue("name-value-separator");
            if (name_value_separator == null || name_value_separator.length() != 1 || " \t=:".indexOf(name_value_separator) < 0) {
                name_value_separator = "=";
            }
            this.appendComments(sb, cs[i].get("COMMENTS"), cs[i].get("SEPARATOR"), lineSeparator);
            if ("no".equals(cs[i].get("ENABLED"))) {
                sb.append('#');
            }
            String dirtyname = cs[i].getAttributeValue("dirtyname");
            String name = EncodedProperties.saveConvert(cs[i].get("NAME"), true);
            String value = cs[i].get("VALUE");
            String dirtyvalue = cs[i].getAttributeValue("dirtyvalue");
            if (value == null || dirtyvalue == null || !value.equals(this.trimLeft(dirtyvalue))) {
                value = EncodedProperties.saveConvert(value, false);
            }
            String resolved = this.resolveValue(value, dirtyvalue);
            if (dirtyvalue != null && dirtyvalue.startsWith(" ") && resolved != null && resolved.length() > 0 && !resolved.startsWith(" ") && !name_value_separator.endsWith(" ")) {
                resolved = " " + resolved;
            }
            if (dirtyname != null && name.equals(dirtyname.trim())) {
                name = dirtyname;
            }
            if (dirtyname != null && dirtyname.endsWith(" ") && name != null && name.length() > 0 && !name.endsWith(" ") && !name_value_separator.startsWith(" ")) {
                name = String.valueOf(name) + " ";
            }
            sb.append(name);
            if (!" ".equals(name_value_separator) || resolved.length() > 0) {
                sb.append(name_value_separator);
            }
            sb.append(resolved);
            String ls = cs[i].get("line-end");
            if (ls.length() > 0) {
                if (ls.equals("\\r\\n")) {
                    ls = lineSeparator;
                }
                sb.append(ls);
            } else if (i < cs.length - 1) {
                ls = lineSeparator;
                sb.append(ls);
            }
            ++i;
        }
        String conclusion = object.get("conclusion");
        if (conclusion != null) {
            sb.append(conclusion);
        }
        return sb.toString();
    }

    private String trimLeft(String s) {
        int qq = 0;
        while (qq < s.length() && s.charAt(qq) <= ' ') {
            ++qq;
        }
        return qq > 0 ? s.substring(qq) : s;
    }

    String resolveValue(String value, String dirtyvalue) {
        if (dirtyvalue == null) {
            return value;
        }
        if (this.trimLeft(dirtyvalue).equals(value)) {
            return dirtyvalue;
        }
        if (dirtyvalue.indexOf(INTERNAL_SEPARATOR) < 0) {
            if (value.equals(this.convertDirtyValue(dirtyvalue))) {
                return dirtyvalue;
            }
            return value;
        }
        StringTokenizer st = new StringTokenizer(dirtyvalue, INTERNAL_SEPARATOR, true);
        StringBuffer cv = new StringBuffer();
        StringBuffer dv = new StringBuffer();
        String rightWhites = "";
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (t.equals(INTERNAL_SEPARATOR)) {
                if (rightWhites.length() > 0) {
                    cv.append(rightWhites);
                    rightWhites = "";
                }
                dv.append("\\");
                continue;
            }
            if (t.startsWith("#")) {
                cv.append("\\");
            }
            String app = t.trim();
            int off = t.indexOf(app);
            rightWhites = t.substring(off + app.length());
            cv.append(app);
            dv.append(t);
        }
        if (value.equals(cv.toString())) {
            return dv.toString();
        }
        if (value.equals(this.convertDirtyValue(cv.toString()))) {
            return dv.toString();
        }
        return value;
    }

    String convertDirtyValue(String dirtyvalue) {
        ByteArrayInputStream sr = new ByteArrayInputStream(("a=" + dirtyvalue).getBytes());
        Properties p = new Properties();
        try {
            p.load(sr);
        }
        catch (IOException iOException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        return p.getProperty("a");
    }

    public void edit(XModelObject object, String body) {
        XModelObject c = object.copy(0);
        XModelObjectLoaderUtil.setTempBody(c, body);
        this.load(c);
        object.fireObjectChanged("beforeMerge");
        try {
            this.merge(object, c);
        }
        finally {
            object.fireObjectChanged("afterMerge");
        }
    }

    private void merge(XModelObject o1, XModelObject o2) {
        String conclusion2;
        String conclusion1;
        XModelObject[] c1 = o1.getChildren();
        HashMap<String, XModelObject> m1 = new HashMap<String, XModelObject>();
        int i = 0;
        while (i < c1.length) {
            m1.put(c1[i].getPathPart(), c1[i]);
            ++i;
        }
        XModelObject[] c2 = o2.getChildren();
        RegularObjectImpl impl1 = (RegularObjectImpl)o1;
        boolean ch = c2.length != c1.length;
        boolean mod = false;
        int i2 = 0;
        while (i2 < c2.length) {
            XModelObject c = (XModelObject)m1.remove(c2[i2].getPathPart());
            if (c == null) {
                c = c2[i2].copy();
                ((XModelObjectImpl)c).setParent_0(impl1);
            } else if (!c.isEqual(c2[i2])) {
                mod = true;
                XAttribute[] as = c.getModelEntity().getAttributes();
                int j = 0;
                while (j < as.length) {
                    if (as[j].isCopyable()) {
                        String n = as[j].getName();
                        String v1 = c.getAttributeValue(n);
                        String v2 = c2[i2].getAttributeValue(n);
                        if (v2 != null && !v2.equals(v1)) {
                            c.setAttributeValue(n, v2);
                        }
                    }
                    ++j;
                }
            }
            if (!ch && c1[i2] != c) {
                ch = true;
            }
            c2[i2] = c;
            ++i2;
        }
        c1 = m1.values().toArray(new XModelObject[0]);
        if (ch || c1.length > 0) {
            impl1.replaceChildren(c2);
            ((XModelImpl)o1.getModel()).fireStructureChanged(o1);
        }
        if ((conclusion1 = o1.get("conclusion")) == null) {
            conclusion1 = "";
        }
        if ((conclusion2 = o2.get("conclusion")) == null) {
            conclusion2 = "";
        }
        if (!conclusion1.equals(conclusion2)) {
            o1.set("conclusion", conclusion2);
            mod = true;
        }
        if (ch || mod) {
            o1.setModified(true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static int getSeparatorIndex(String s) {
        tr = s.trim();
        if (tr.length() == 0 || tr.charAt(0) == '#' || tr.charAt(0) == '!') {
            return -1;
        }
        n = false;
        backslash = false;
        firstWhiteSpace = -1;
        i = 0;
        while (i < s.length()) {
            c = s.charAt(i);
            if (backslash && (c == ' ' || c == 't' || c == 'n')) ** GOTO lbl22
            if (Character.isWhitespace(c)) {
                if (n && firstWhiteSpace < 0) {
                    firstWhiteSpace = i;
                }
            } else {
                if (c == '=' || c == ':') {
                    if (!backslash) {
                        return i;
                    }
                } else {
                    if (n && firstWhiteSpace >= 0) {
                        return firstWhiteSpace;
                    }
                    n = true;
                }
lbl22:
                // 3 sources

                backslash = c == '\\' ? backslash == false : false;
            }
            ++i;
        }
        return s.length();
    }
}

