/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl.trees;

import java.util.ArrayList;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.model.XFilteredTreeConstraint;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.impl.trees.DefaultSiftedTree;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.ModelFeatureFactory;

public class FileSystemsTree
extends DefaultSiftedTree {
    private XFilteredTreeConstraint[] constraints = new XFilteredTreeConstraint[0];
    protected String prefix = this.createPrefix();

    @Override
    public void dispose() {
    }

    protected String createPrefix() {
        return "FileSystems$";
    }

    @Override
    public void setModel(XModel model) {
        this.model = model;
        XModelObject root = this.getRoot();
        if (root instanceof FileSystemsImpl) {
            FileSystemsImpl fs = (FileSystemsImpl)root;
            fs.updateOverlapped();
        }
        this.load();
    }

    @Override
    public XModelObject getRoot() {
        return FileSystemsHelper.getFileSystems(this.model);
    }

    private void load() {
        XMapping m = this.model.getMetaData().getMapping("FilteredTreeConstraints");
        if (m == null) {
            return;
        }
        ArrayList<XFilteredTreeConstraint> l = new ArrayList<XFilteredTreeConstraint>();
        String[] ks = m.getKeys();
        int i = 0;
        while (i < ks.length) {
            if (this.isConstraintRelevant(ks[i])) {
                String v = m.getValue(ks[i]);
                XFilteredTreeConstraint c = null;
                try {
                    c = (XFilteredTreeConstraint)ModelFeatureFactory.getInstance().createFeatureInstance(v);
                }
                catch (ClassCastException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                }
                if (c != null) {
                    c.update(this.model);
                    l.add(c);
                }
            }
            ++i;
        }
        this.constraints = l.toArray(new XFilteredTreeConstraint[l.size()]);
    }

    protected boolean isConstraintRelevant(String key) {
        return key.startsWith(this.prefix);
    }

    @Override
    public boolean hasChildren(XModelObject object) {
        int i = 0;
        while (i < this.constraints.length) {
            if (this.constraints[i].isHidingAllChildren(object)) {
                return false;
            }
            ++i;
        }
        return super.hasChildren(object);
    }

    @Override
    public XModelObject[] getChildren(XModelObject object) {
        if (!this.hasChildren(object)) {
            return new XModelObject[0];
        }
        int i = 0;
        while (i < this.constraints.length) {
            if (this.constraints[i].isHidingSomeChildren(object)) {
                return this.getNonHiddenChildren(object);
            }
            ++i;
        }
        return super.getChildren(object);
    }

    private XModelObject[] getNonHiddenChildren(XModelObject object) {
        ArrayList<XModelObject> l = new ArrayList<XModelObject>();
        XModelObject[] os = object.getChildren();
        int i = 0;
        while (i < os.length) {
            if (this.accepts(os[i])) {
                l.add(os[i]);
            }
            ++i;
        }
        return l.toArray(new XModelObject[l.size()]);
    }

    private boolean accepts(XModelObject object) {
        int i = 0;
        while (i < this.constraints.length) {
            if (!this.constraints[i].accepts(object)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public XModelObject getRepresentation(XModelObject object) {
        return object;
    }
}

