/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.filesystems.impl.Libs;

class LibraryNames {
    private Map<String, String> pathToName = new HashMap<String, String>();
    private Map<String, String> nameToPath = new HashMap<String, String>();

    LibraryNames() {
    }

    public synchronized void put(String path, String name) {
        this.pathToName.put(path, name);
        this.nameToPath.put(name, path);
    }

    public synchronized void removePath(String path) {
        String name = this.pathToName.remove(path);
        if (name != null) {
            this.nameToPath.remove(name);
        }
    }

    public String getName(String path) {
        return this.pathToName.get(path);
    }

    public synchronized String getExistingOrNewName(String path, String fileName) {
        String jsname = this.getName(path);
        if (jsname == null) {
            jsname = String.valueOf(Libs.LIB_PREFIX) + fileName;
            int q = 0;
            while (this.hasName(jsname)) {
                jsname = String.valueOf(Libs.LIB_PREFIX) + fileName + "-" + ++q;
            }
        }
        return jsname;
    }

    public String getPath(String name) {
        return this.nameToPath.get(name);
    }

    public boolean hasName(String name) {
        return this.nameToPath.containsKey(name);
    }

    public synchronized Set<String> getPaths() {
        return new HashSet<String>(this.pathToName.keySet());
    }

    public synchronized boolean isValidList(List<String> paths) {
        if (this.pathToName.size() != paths.size()) {
            return false;
        }
        for (String p : paths) {
            if (this.pathToName.containsKey(p)) continue;
            return false;
        }
        return true;
    }
}

