/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.constraint.XProperty;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.BodySource;
import org.jboss.tools.common.model.filesystems.FilePathHelper;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderLoader;
import org.jboss.tools.common.model.filesystems.impl.JarFolderImpl;
import org.jboss.tools.common.model.impl.RegularObjectImpl;

public class FileAnyImpl
extends RegularObjectImpl {
    private static final long serialVersionUID = 5613864065417244573L;
    private BodySource bodysource = null;
    BodyListener listener;
    int updateLock = 0;

    public void setUpdateLock() {
        ++this.updateLock;
    }

    public void releaseUpdateLock() {
        --this.updateLock;
    }

    public void addListener(BodyListener listener) {
        this.listener = listener;
    }

    public void removeListener(BodyListener listener) {
        if (this.listener == listener) {
            this.listener = null;
        }
    }

    @Override
    public void setModified(boolean value) {
        XModelObject p;
        boolean changed = this.isModified() ^ value;
        if (changed && value && (p = this.getParent()) instanceof JarFolderImpl) {
            return;
        }
        super.setModified(value);
        if (changed && this.isActive() && this.updateLock <= 0) {
            this.fireObjectChanged("setModified");
            if (value) {
                this.saveUnopen();
            }
        }
    }

    @Override
    public boolean isObjectEditable() {
        return this.isObjectEditable0();
    }

    private boolean isObjectEditable0() {
        if ("true".equals(this.get("overlapped")) && this.isActive()) {
            return false;
        }
        XModelObject p = this.getParent();
        if (p == null) {
            return true;
        }
        if (p instanceof JarFolderImpl) {
            return false;
        }
        if (p instanceof FolderImpl) {
            return ((FolderImpl)p).isChildEditable(this);
        }
        return true;
    }

    @Override
    public boolean isAttributeEditable(String name) {
        if ("name".equals(name) || "extension".equals(name)) {
            return false;
        }
        if ("body".equals(name)) {
            return this.isObjectEditable0();
        }
        return super.isAttributeEditable(name);
    }

    @Override
    public String getMainIconName() {
        if ("true".equals(this.get("overlapped")) && this.isActive()) {
            XModelObject o;
            String oin = this.get("overlappedSystem");
            XModelObject xModelObject = o = oin == null || oin.length() == 0 ? null : this.getModel().getByPath(oin);
            if (o == null) {
                o = this;
                while (o != null && o.getFileType() != 3) {
                    o = o.getParent();
                }
            }
            if (o != null) {
                return o.getMainIconName();
            }
        }
        return super.getMainIconName();
    }

    @Override
    public String name() {
        return FileAnyImpl.toFileName(this);
    }

    @Override
    public int getFileType() {
        return 1;
    }

    @Override
    public String getPathPart() {
        String n = this.name();
        String pp = FilePathHelper.toPathPath(n);
        return n == null ? null : pp;
    }

    public static String toFileName(XProperty p) {
        String n = p.get("NAME");
        if (n == null) {
            return null;
        }
        String s = p.get("EXTENSION");
        return String.valueOf(n) + (s == null || s.length() == 0 ? "" : "." + s);
    }

    public void setBodySource(BodySource bodysource) {
        this.bodysource = bodysource;
        super.set("body", "");
        this.changeTimeStamp();
    }

    public void updateBodySource() {
        XModelObject o = this.getParent();
        if (!(o instanceof FolderLoader)) {
            return;
        }
        FolderLoader f = (FolderLoader)((Object)o);
        this.bodysource = f.getBodySource(FileAnyImpl.toFileName(this));
    }

    public BodySource getBodySource() {
        return this.bodysource;
    }

    @Override
    public String get(String name) {
        if (this.bodysource != null && "body".equals(name)) {
            this.readBodySource();
        }
        return super.get(name);
    }

    private void readBodySource() {
        String s = this.bodysource.get();
        this.bodysource = null;
        if (s != null) {
            super.set("body", s);
        }
    }

    @Override
    public String setAttributeValue(String name, String value) {
        return super.setAttributeValue(name, value);
    }

    public String getAsText() {
        return this.getAttributeValue("body");
    }

    public void edit(String body) throws XModelException {
        this.getModel().changeObjectAttribute(this, "body", body);
    }

    @Override
    public void set(String name, String value) {
        if (!"NAME".equals(name) && !"EXTENSION".equals(name) || !this.isActive() || !(this.getParent() instanceof FolderImpl)) {
            super.set(name, value);
        } else {
            this.rename0(value, name);
        }
    }

    public void fileRenamed(String name, String extension) {
        if (name != null && name.equals(super.get("NAME")) && extension != null && extension.equals(super.get("EXTENSION"))) {
            return;
        }
        super.set("NAME", name);
        super.set("EXTENSION", extension);
        this.safeChangeTimeStamp();
        this.fireObjectChanged(null);
    }

    void rename0(String value, String attr) {
        FolderImpl p = (FolderImpl)this.getParent();
        IFile f = p.getChildFile(FileAnyImpl.toFileName(this));
        String n1 = this.get(attr);
        super.set(attr, value);
        String n2 = this.get(attr);
        IFile f2 = p.getChildFile(FileAnyImpl.toFileName(this));
        if (f2.exists() && !f.exists()) {
            return;
        }
        if (!n2.equals(n1)) {
            try {
                f.move((IPath)new Path(f.getParent().getFullPath() + "/" + FileAnyImpl.toFileName(this)), true, null);
            }
            catch (OperationCanceledException operationCanceledException) {
                super.set(attr, n1);
            }
            catch (CoreException coreException) {
                super.set(attr, n1);
            }
        }
    }

    public String getAbsolutePath() {
        if (!(this.getParent() instanceof FolderImpl)) {
            return null;
        }
        FolderImpl p = (FolderImpl)this.getParent();
        File f = p.getFile();
        if (f == null) {
            return null;
        }
        if ((f = new File(f, FileAnyImpl.toFileName(this))).isFile()) {
            try {
                return f.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException iOException) {}
        }
        return f.getAbsolutePath().replace('\\', '/');
    }

    public IFile getFile() {
        if (!(this.getParent() instanceof FolderImpl)) {
            return null;
        }
        return ((FolderImpl)this.getParent()).getChildFile(FileAnyImpl.toFileName(this));
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IResource.class == adapter || IFile.class == adapter) {
            return this.getFile();
        }
        return super.getAdapter(adapter);
    }

    private void saveUnopen() {
        if (!this.isModified() || !this.isActive()) {
            return;
        }
        XJob.addRunnableWithPriority(new XJob.XRunnable(){

            @Override
            public String getId() {
                return "Save " + FileAnyImpl.this.getPath();
            }

            @Override
            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        FileAnyImpl.this.saveUnopen0();
                    }
                });
            }
        });
    }

    private void saveUnopen0() {
        if (!this.isActive()) {
            return;
        }
        if (!this.isModified()) {
            return;
        }
        SpecialWizard w = SpecialWizardFactory.createSpecialWizard("org.jboss.tools.common.model.ui.objecteditor.SaveUnopenSpecialWizard");
        if (w == null) {
            return;
        }
        w.setObject(this);
        w.execute();
    }

    @Override
    protected void onAttributeValueEdit(String name, String oldValue, String newValue) throws XModelException {
        if ("body".equals(name) && this.listener != null) {
            this.listener.bodyChanged(newValue);
        }
    }

    public static interface BodyListener {
        public void bodyChanged(String var1);
    }
}

