/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.locators;

import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.maven.ProjectImpl;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.locator.ProjectLocator;
import org.jboss.forge.project.services.ProjectFactory;
import org.jboss.forge.resources.DirectoryResource;
import org.jboss.forge.resources.Resource;

public class MavenProjectLocator
implements ProjectLocator {
    private final ProjectFactory factory;
    private final Instance<MavenCoreFacet> coreFacetInstance;

    @Inject
    public MavenProjectLocator(ProjectFactory factory, @Any Instance<MavenCoreFacet> coreFacet) {
        this.factory = factory;
        this.coreFacetInstance = coreFacet;
    }

    public Project createProject(DirectoryResource dir) {
        ProjectImpl result = new ProjectImpl(this.factory, dir);
        MavenCoreFacet maven = (MavenCoreFacet)this.coreFacetInstance.get();
        maven.setProject((Project)result);
        if (!maven.isInstalled()) {
            result.installFacet((Facet)maven);
        } else {
            result.registerFacet((Facet)maven);
        }
        if (!result.hasFacet(MavenCoreFacet.class)) {
            throw new IllegalStateException("Could not create Maven project [MavenCoreFacet could not be installed.]");
        }
        return result;
    }

    public boolean containsProject(DirectoryResource dir) {
        Resource pom = dir.getChild("pom.xml");
        return pom.exists();
    }
}

