/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import java.io.File;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.repository.internal.MavenRepositorySystemSession;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.jboss.forge.ForgeEnvironment;
import org.jboss.forge.maven.RepositoryUtils;
import org.jboss.forge.project.ProjectModelException;
import org.jboss.forge.shell.util.OSUtils;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.impl.internal.SimpleLocalRepositoryManager;
import org.sonatype.aether.repository.LocalRepositoryManager;
import org.sonatype.aether.repository.ProxySelector;
import org.sonatype.aether.util.repository.DefaultProxySelector;

@ApplicationScoped
public class MavenContainer {
    private static final String M2_HOME = System.getenv().get("M2_HOME");
    private ProjectBuildingRequest request;
    private DefaultPlexusContainer container = null;
    private ProjectBuilder builder = null;
    @Inject
    private ForgeEnvironment environment;

    public ProjectBuildingRequest getRequest() {
        return this.getBuildingRequest(!this.environment.isOnline());
    }

    public ProjectBuildingRequest getOfflineRequest() {
        return this.getBuildingRequest(true);
    }

    public ProjectBuildingRequest getBuildingRequest(boolean offline) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Settings settings = this.getSettings();
            DefaultMavenExecutionRequest executionRequest = new DefaultMavenExecutionRequest();
            this.lookup(MavenExecutionRequestPopulator.class).populateFromSettings((MavenExecutionRequest)executionRequest, this.getSettings());
            this.request = executionRequest.getProjectBuildingRequest();
            MavenArtifactRepository localRepository = new MavenArtifactRepository("local", new File(settings.getLocalRepository()).toURI().toURL().toString(), (ArtifactRepositoryLayout)this.getContainer().lookup(ArtifactRepositoryLayout.class), new ArtifactRepositoryPolicy(true, "never", "warn"), new ArtifactRepositoryPolicy(true, "never", "warn"));
            this.request.setLocalRepository((ArtifactRepository)localRepository);
            this.request.setSystemProperties(System.getProperties());
            MavenRepositorySystemSession repositorySession = new MavenRepositorySystemSession();
            Proxy activeProxy = settings.getActiveProxy();
            if (activeProxy != null) {
                DefaultProxySelector dps = new DefaultProxySelector();
                dps.add(RepositoryUtils.convertFromMavenProxy(activeProxy), activeProxy.getNonProxyHosts());
                repositorySession.setProxySelector((ProxySelector)dps);
            }
            repositorySession.setLocalRepositoryManager((LocalRepositoryManager)new SimpleLocalRepositoryManager(settings.getLocalRepository()));
            repositorySession.setOffline(offline);
            this.request.setRepositorySession((RepositorySystemSession)repositorySession);
            this.request.setProcessPlugins(false);
            this.request.setResolveDependencies(false);
            ProjectBuildingRequest projectBuildingRequest = this.request;
            return projectBuildingRequest;
        }
        catch (Exception e) {
            throw new ProjectModelException("Could not create Maven project building request", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public Settings getSettings() {
        try {
            SettingsBuildingResult settingsBuildingResult;
            Settings effectiveSettings;
            DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
            DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
            settingsRequest.setUserSettingsFile(new File(OSUtils.getUserHomeDir().getAbsolutePath() + "/.m2/settings.xml"));
            if (M2_HOME != null) {
                settingsRequest.setGlobalSettingsFile(new File(M2_HOME + "/conf/settings.xml"));
            }
            if ((effectiveSettings = (settingsBuildingResult = settingsBuilder.build((SettingsBuildingRequest)settingsRequest)).getEffectiveSettings()).getLocalRepository() == null) {
                effectiveSettings.setLocalRepository(OSUtils.getUserHomeDir().getAbsolutePath() + "/.m2/repository");
            }
            return effectiveSettings;
        }
        catch (SettingsBuildingException e) {
            throw new ProjectModelException((Throwable)e);
        }
    }

    public ProjectBuilder getBuilder() {
        return this.builder;
    }

    public <T> T lookup(Class<T> type) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Object object = this.getContainer().lookup(type);
            return (T)object;
        }
        catch (ComponentLookupException e) {
            throw new ProjectModelException("Could not look up component of type [" + type.getName() + "]", (Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    private DefaultPlexusContainer getContainer() {
        if (this.container == null) {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                this.container = new DefaultPlexusContainer();
                ConsoleLoggerManager loggerManager = new ConsoleLoggerManager();
                loggerManager.setThreshold("ERROR");
                this.getContainer().setLoggerManager((LoggerManager)loggerManager);
                this.builder = (ProjectBuilder)this.getContainer().lookup(ProjectBuilder.class);
            }
            catch (Exception e) {
                throw new ProjectModelException("Could not initialize Maven", (Throwable)e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        return this.container;
    }
}

