/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template.resolver;

import org.jboss.seam.render.spi.TemplateResolver;
import org.jboss.seam.render.spi.TemplateResource;
import org.jboss.seam.render.template.resource.ClassLoaderTemplateResource;
import org.jboss.seam.render.util.Assert;
import org.jboss.seam.render.util.Paths;

public class ThreadContextClassLoaderTemplateResolver
implements TemplateResolver<ClassLoader> {
    private final ClassLoader loader = Thread.currentThread().getContextClassLoader();

    @Override
    public TemplateResource<ClassLoader> resolve(String path) {
        Assert.notNull(path, "Resource path must not be null.");
        if (this.isValid(path)) {
            return new ClassLoaderTemplateResource(this, this.loader, path);
        }
        return null;
    }

    @Override
    public TemplateResource<ClassLoader> resolveRelative(TemplateResource<ClassLoader> origin, String relativePath) {
        Assert.notNull(origin, "Origin resource must not be null.");
        Assert.notNull(relativePath, "Relative resource path must not be null.");
        String path = origin.getPath();
        path = Paths.calculateRelativePath(path, relativePath);
        if (this.isValid(path)) {
            return new ClassLoaderTemplateResource(this, this.loader, path);
        }
        return null;
    }

    private boolean isValid(String target) {
        return this.loader.getResource(target) != null;
    }
}

