/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin;

import javax.inject.Inject;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.Topic;

@Alias(value="rm")
@Topic(value="File & Resources")
@Help(value="Removes a resource")
public class RmPlugin
implements Plugin {
    private final Shell shell;

    @Inject
    public RmPlugin(Shell shell) {
        this.shell = shell;
    }

    @DefaultCommand
    public void rm(@Option(name="recursive", shortName="r", help="recursively delete resources", flagOnly=true) boolean recursive, @Option(name="force", shortName="f", help="do not prompt to confirm operations", flagOnly=true) boolean force, @Option(description="path", required=true) Resource<?>[] paths) {
        for (Resource<?> resource : paths) {
            if (!force && !this.shell.promptBoolean("delete: " + resource.getName() + ": are you sure?") || resource.delete(recursive)) continue;
            throw new RuntimeException("error deleting files.");
        }
    }
}

