/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.console.jline;

import java.io.IOException;
import java.io.InputStream;
import java.util.ResourceBundle;
import org.jboss.forge.shell.console.jline.Terminal;
import org.jboss.forge.shell.console.jline.TerminalFactory;
import org.jboss.forge.shell.console.jline.internal.Log;

public abstract class TerminalSupport
implements Terminal {
    public static String DEFAULT_KEYBINDINGS_PROPERTIES = "keybindings.properties";
    public static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_HEIGHT = 24;
    private Thread shutdownHook;
    private boolean supported;
    private boolean echoEnabled;
    private boolean ansiSupported;

    protected TerminalSupport(boolean supported) {
        this.supported = supported;
    }

    @Override
    public void init() throws Exception {
        this.installShutdownHook(new RestoreHook());
    }

    @Override
    public void restore() throws Exception {
        TerminalFactory.resetIf(this);
        this.removeShutdownHook();
    }

    @Override
    public void reset() throws Exception {
        this.restore();
        this.init();
    }

    protected void installShutdownHook(Thread hook) {
        assert (hook != null);
        if (this.shutdownHook != null) {
            throw new IllegalStateException("Shutdown hook already installed");
        }
        try {
            Runtime.getRuntime().addShutdownHook(hook);
            this.shutdownHook = hook;
        }
        catch (AbstractMethodError e) {
            Log.trace("Failed to register shutdown hook: ", e);
        }
    }

    protected void removeShutdownHook() {
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (AbstractMethodError e) {
                Log.trace("Failed to remove shutdown hook: ", e);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.shutdownHook = null;
        }
    }

    @Override
    public final boolean isSupported() {
        return this.supported;
    }

    @Override
    public synchronized boolean isAnsiSupported() {
        return this.ansiSupported;
    }

    protected synchronized void setAnsiSupported(boolean supported) {
        this.ansiSupported = supported;
        Log.debug("Ansi supported: ", supported);
    }

    @Override
    public int getWidth() {
        return 80;
    }

    @Override
    public int getHeight() {
        return 24;
    }

    @Override
    public synchronized boolean isEchoEnabled() {
        return this.echoEnabled;
    }

    @Override
    public synchronized void setEchoEnabled(boolean enabled) {
        this.echoEnabled = enabled;
        Log.debug("Echo enabled: ", enabled);
    }

    @Override
    public int readCharacter(InputStream in) throws IOException {
        return in.read();
    }

    @Override
    public int readVirtualKey(InputStream in) throws IOException {
        return this.readCharacter(in);
    }

    @Override
    public ResourceBundle getDefaultBindings() {
        return ResourceBundle.getBundle("org.jboss.forge.keybindings");
    }

    protected class RestoreHook
    extends Thread {
        protected RestoreHook() {
        }

        @Override
        public void start() {
            try {
                TerminalSupport.this.restore();
            }
            catch (Exception e) {
                Log.trace("Failed to restore: ", e);
            }
        }
    }
}

