/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.parser;

import java.util.Queue;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.shell.command.CommandMetadata;
import org.jboss.forge.shell.command.OptionMetadata;
import org.jboss.forge.shell.command.parser.CommandParser;
import org.jboss.forge.shell.command.parser.CommandParserContext;

public class NamedValueOptionParser
implements CommandParser {
    @Override
    public CommandParserContext parse(CommandMetadata command, Queue<String> tokens, CommandParserContext ctx) {
        String currentToken = tokens.peek();
        if (currentToken.startsWith("--")) {
            try {
                currentToken = currentToken.substring(2);
                if (command.hasOption(currentToken)) {
                    OptionMetadata option = command.getNamedOption(currentToken);
                    tokens.remove();
                    if (!option.isBoolean()) {
                        String nextToken;
                        String value = null;
                        if (!tokens.isEmpty() && !(nextToken = tokens.peek()).startsWith("--")) {
                            value = nextToken;
                            tokens.remove();
                        }
                        ctx.put(option, Strings.stripQuotes(value), Strings.stripQuotes(value));
                    }
                }
            }
            catch (IllegalArgumentException e) {
                ctx.addWarning("No such option [--" + currentToken + "] for command [" + command + "].");
            }
        }
        return ctx;
    }
}

