/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.forge.parser.java.util.Assert;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.xml.Node;
import org.jboss.forge.parser.xml.XMLParser;
import org.jboss.forge.parser.xml.XMLParserException;
import org.jboss.forge.shell.util.OSUtils;
import org.jboss.forge.shell.util.Streams;

public class InstalledPluginRegistry {
    private static final String DEFAULT_SLOT = "main";
    private static final String ATTR_SLOT = "slot";
    private static final String ATTR_API_VERSION = "api-version";
    private static final String ATTR_NAME = "name";
    private static final String PLUGIN_DIR_DEFAULT = "/.forge/plugins";
    private static final String REGISTRY_FILE = "/installed.xml";
    private static String PLUGIN_DIR = null;
    private static String REGISTRY = null;

    private static String getPluginDir() {
        if (PLUGIN_DIR == null && (PLUGIN_DIR = System.getProperty("org.jboss.forge.pluginDir")) == null) {
            PLUGIN_DIR = OSUtils.getUserHomePath() + PLUGIN_DIR_DEFAULT;
        }
        return PLUGIN_DIR;
    }

    private static String getRegistry() {
        if (REGISTRY == null) {
            REGISTRY = InstalledPluginRegistry.getPluginDir() + REGISTRY_FILE;
        }
        return REGISTRY;
    }

    public static File getRegistryFile() {
        return new File(InstalledPluginRegistry.getRegistry());
    }

    public static List<PluginEntry> listByAPICompatibleVersion(String version) {
        List<PluginEntry> list;
        List<PluginEntry> result = list = InstalledPluginRegistry.list();
        if (version != null) {
            result = new ArrayList<PluginEntry>();
            for (PluginEntry entry : list) {
                if (!InstalledPluginRegistry.isApiCompatible((CharSequence)version, entry)) continue;
                result.add(entry);
            }
        }
        return result;
    }

    public static List<PluginEntry> list() {
        ArrayList<PluginEntry> result = new ArrayList<PluginEntry>();
        File registryFile = InstalledPluginRegistry.getRegistryFile();
        try {
            Node installed = XMLParser.parse((InputStream)new FileInputStream(registryFile));
            List list = installed.get("plugin");
            for (Node plugin : list) {
                PluginEntry entry = new PluginEntry(plugin.getAttribute(ATTR_NAME), plugin.getAttribute(ATTR_API_VERSION), plugin.getAttribute(ATTR_SLOT));
                result.add(entry);
            }
        }
        catch (XMLParserException e) {
            throw new RuntimeException("Invalid syntax in [" + registryFile.getAbsolutePath() + "] - Please delete this file and restart Forge", e);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static PluginEntry install(String name, String apiVersion, String slot) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new RuntimeException("Plugin must not be null");
        }
        if (Strings.isNullOrEmpty((String)apiVersion)) {
            throw new RuntimeException("API version must not be null");
        }
        if (Strings.isNullOrEmpty((String)slot)) {
            slot = DEFAULT_SLOT;
        }
        List<PluginEntry> installedPlugins = InstalledPluginRegistry.list();
        for (PluginEntry e : installedPlugins) {
            if (!name.equals(e.getName())) continue;
            InstalledPluginRegistry.remove(e);
        }
        Node installed = null;
        File registryFile = InstalledPluginRegistry.getRegistryFile();
        try {
            if (registryFile.exists()) {
                installed = XMLParser.parse((InputStream)new FileInputStream(registryFile));
            } else {
                registryFile.mkdirs();
                registryFile.delete();
                registryFile.createNewFile();
                installed = XMLParser.parse((String)"<installed></installed>");
            }
            installed.getOrCreate("plugin@name=" + name + "&" + ATTR_API_VERSION + "=" + apiVersion).attribute(ATTR_SLOT, slot);
            Streams.write((InputStream)XMLParser.toXMLInputStream((Node)installed), (OutputStream)new FileOutputStream(registryFile));
            return new PluginEntry(name, apiVersion, slot);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Could not read [" + registryFile.getAbsolutePath() + "] - ", e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error manipulating [" + registryFile.getAbsolutePath() + "] - ", e);
        }
    }

    public static void remove(PluginEntry plugin) {
        if (plugin == null) {
            throw new RuntimeException("Plugin must not be null");
        }
        File registryFile = InstalledPluginRegistry.getRegistryFile();
        if (registryFile.exists()) {
            try {
                Node installed = XMLParser.parse((InputStream)new FileInputStream(registryFile));
                Node child = installed.getSingle("plugin@name=" + plugin.getName() + "&" + ATTR_API_VERSION + "=" + plugin.getApiVersion());
                installed.removeChild(child);
                Streams.write((InputStream)XMLParser.toXMLInputStream((Node)installed), (OutputStream)new FileOutputStream(registryFile));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public static PluginEntry get(PluginEntry plugin) {
        if (plugin == null) {
            throw new RuntimeException("Plugin must not be null");
        }
        File registryFile = InstalledPluginRegistry.getRegistryFile();
        if (registryFile.exists()) {
            try {
                Node installed = XMLParser.parse((InputStream)new FileInputStream(registryFile));
                List children = installed.get("plugin@name=" + plugin.getName());
                for (Node child : children) {
                    if (child == null || plugin.getApiVersion() != null && !plugin.getApiVersion().equals(child.getAttribute(ATTR_API_VERSION)) || plugin.getSlot() != null && !plugin.getSlot().equals(child.getAttribute(ATTR_SLOT))) continue;
                    return new PluginEntry(child.getAttribute(ATTR_NAME), child.getAttribute(ATTR_API_VERSION), child.getAttribute(ATTR_SLOT));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean has(PluginEntry plugin) {
        return InstalledPluginRegistry.get(plugin) != null;
    }

    public static String getRuntimeAPIVersion() {
        return InstalledPluginRegistry.class.getPackage().getImplementationVersion();
    }

    public static boolean isApiCompatible(CharSequence runtimeVersion, PluginEntry entry) {
        Assert.notNull((Object)runtimeVersion, (String)"Runtime API version must not be null.");
        Assert.notNull((Object)entry, (String)"Plugin entry must not be null.");
        String pluginApiVersion = entry.getApiVersion();
        Assert.notNull((Object)pluginApiVersion, (String)"Plugin entry.getApiVersion() must not be null.");
        return InstalledPluginRegistry.isApiCompatible(runtimeVersion, pluginApiVersion);
    }

    public static boolean isApiCompatible(CharSequence runtimeVersion, String pluginApiVersion) {
        Pattern runtimeVersionPattern = Pattern.compile("(\\d+)\\.(\\d+)\\.(\\d+)(\\.|-)(.*)");
        Matcher matcher = runtimeVersionPattern.matcher(runtimeVersion);
        return matcher.matches() && pluginApiVersion.matches(matcher.group(1) + "\\." + matcher.group(2) + "\\.(\\d+).*");
    }

    public static class PluginEntry {
        private final String name;
        private final String apiVersion;
        private final String slot;

        public PluginEntry(String name, String apiVersion, String slot) {
            this.name = name;
            this.apiVersion = apiVersion;
            this.slot = slot;
        }

        public PluginEntry(String name, String apiVersion) {
            this.name = name;
            this.apiVersion = apiVersion;
            this.slot = null;
        }

        public PluginEntry(String name) {
            this.name = name;
            this.apiVersion = null;
            this.slot = null;
        }

        public String getName() {
            return this.name;
        }

        public String getApiVersion() {
            return this.apiVersion;
        }

        public String getSlot() {
            return this.slot;
        }

        public String toString() {
            return this.name + ":" + this.apiVersion + ":" + this.slot;
        }

        public static PluginEntry fromCoordinates(String coordinates) {
            String[] split = coordinates.split(":");
            List<String> tokens = Arrays.asList(split);
            if (tokens.size() == 3) {
                if (Strings.isNullOrEmpty((String)tokens.get(0))) {
                    throw new IllegalArgumentException("Name was empty [" + coordinates + "]");
                }
                if (Strings.isNullOrEmpty((String)tokens.get(1))) {
                    throw new IllegalArgumentException("Version was empty [" + coordinates + "]");
                }
                if (Strings.isNullOrEmpty((String)tokens.get(2))) {
                    throw new IllegalArgumentException("Slot was empty [" + coordinates + "]");
                }
                return new PluginEntry(tokens.get(0), tokens.get(1), tokens.get(2));
            }
            throw new IllegalArgumentException("Coordinates must be of the form 'name:apiVersion:slot'");
        }

        public String toModuleId() {
            return this.name + ":" + this.slot;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.apiVersion == null ? 0 : this.apiVersion.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.slot == null ? 0 : this.slot.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PluginEntry other = (PluginEntry)obj;
            if (this.apiVersion == null ? other.apiVersion != null : !this.apiVersion.equals(other.apiVersion)) {
                return false;
            }
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.slot == null ? other.slot != null : !this.slot.equals(other.slot));
        }

        public String toCoordinates() {
            return this.toString();
        }
    }
}

