/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.forge.project.services.ResourceFactory;
import org.jboss.forge.resources.FileResource;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.InvalidInput;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.command.PromptTypeConverter;
import org.jboss.forge.shell.completer.CommandCompleter;
import org.jboss.forge.shell.completer.CompleterAdaptor;
import org.jboss.forge.shell.completer.EnumCompleter;
import org.jboss.forge.shell.console.jline.console.completer.Completer;
import org.jboss.forge.shell.console.jline.console.completer.FileNameCompleter;
import org.jboss.forge.shell.util.BeanManagerUtils;
import org.jboss.forge.shell.util.Enums;
import org.jboss.forge.shell.util.Files;
import org.mvel2.DataConversion;

public abstract class AbstractShellPrompt
implements Shell {
    abstract BeanManager getBeanManager();

    protected abstract PromptTypeConverter getPromptTypeConverter();

    protected abstract ResourceFactory getResourceFactory();

    protected abstract String promptWithCompleter(String var1, Completer var2);

    public String prompt() {
        return this.prompt("");
    }

    public String prompt(String message, String defaultIfEmpty) {
        return this.prompt(message, String.class, defaultIfEmpty);
    }

    public String promptAndSwallowCR() {
        int c;
        StringBuilder buf = new StringBuilder();
        while ((c = this.scan()) != 10 && c != 13) {
            if (c == 127 || c == 8) {
                if (buf.length() <= 0) continue;
                buf.deleteCharAt(buf.length() - 1);
                this.cursorLeft(1);
                this.print(" ");
                this.cursorLeft(1);
                this.flush();
                continue;
            }
            this.write((byte)c);
            buf.append((char)c);
            this.flush();
        }
        return buf.toString();
    }

    public String prompt(String message) {
        return this.promptCompleter(message, null);
    }

    public String promptCompleter(String string, Class<? extends CommandCompleter> type) {
        return this.promptWithCompleter(string, new CompleterAdaptor((CommandCompleter)BeanManagerUtils.getContextualInstance((BeanManager)this.getBeanManager(), type)));
    }

    public <T> T prompt(String message, Class<T> clazz) {
        Object result;
        do {
            String input = this.prompt(message);
            try {
                result = DataConversion.convert((Object)input, clazz);
            }
            catch (Exception e) {
                result = InvalidInput.INSTANCE;
            }
        } while (result instanceof InvalidInput);
        return (T)result;
    }

    public <T> T prompt(String message, Class<T> clazz, T defaultIfEmpty) {
        Object result;
        if (this.isAcceptDefaults()) {
            return defaultIfEmpty;
        }
        do {
            String input;
            String query = " [" + defaultIfEmpty + "] ";
            if (defaultIfEmpty instanceof Boolean) {
                query = Boolean.TRUE.equals(defaultIfEmpty) ? " [Y/n] " : " [y/N] ";
            }
            if ((input = this.prompt(message + query)) == null || "".equals(input.trim())) {
                result = defaultIfEmpty;
                continue;
            }
            input = input.trim();
            try {
                result = DataConversion.convert((Object)input, clazz);
            }
            catch (Exception e) {
                result = InvalidInput.INSTANCE;
            }
        } while (result instanceof InvalidInput);
        return result;
    }

    public boolean promptBoolean(String message) {
        return this.promptBoolean(message, true);
    }

    public boolean promptBoolean(String message, boolean defaultIfEmpty) {
        return this.prompt(message, Boolean.class, defaultIfEmpty);
    }

    public int promptChoice(String message, Object ... options) {
        return this.promptChoice(message, Arrays.asList(options));
    }

    public int promptChoice(String message, List<?> options) {
        if (options == null || options.isEmpty()) {
            throw new IllegalArgumentException("promptChoice() Cannot ask user to select from a list of nothing. Ensure you have values in your options list.");
        }
        this.println(message);
        InvalidInput result = InvalidInput.INSTANCE;
        while (result instanceof InvalidInput) {
            int count = 1;
            this.println();
            for (Object entry : options) {
                if (entry != null) {
                    this.println("  " + count + " - [" + entry + "]");
                } else {
                    this.println("  " + count + " - (none)");
                }
                ++count;
            }
            this.println();
            int input = this.prompt("Choose an option by typing the number of the selection: ", Integer.class) - 1;
            if (input < options.size()) {
                return input;
            }
            this.println("Invalid selection, please try again.");
        }
        return -1;
    }

    public <T> T promptChoiceTyped(String message, List<T> options) {
        if (options == null || options.isEmpty()) {
            throw new IllegalArgumentException("promptChoice() Cannot ask user to select from a list of nothing. Ensure you have values in your options list.");
        }
        if (options.size() == 1) {
            return options.get(0);
        }
        this.println(message);
        InvalidInput result = InvalidInput.INSTANCE;
        while (result instanceof InvalidInput) {
            int count = 1;
            this.println();
            for (T entry : options) {
                if (entry != null) {
                    this.println("  " + count + " - [" + entry + "]");
                } else {
                    this.println("  " + count + " - (none)");
                }
                ++count;
            }
            this.println();
            int input = this.prompt("Choose an option by typing the number of the selection: ", Integer.class) - 1;
            if (input >= 0 && input < options.size()) {
                result = options.get(input);
                continue;
            }
            this.println("Invalid selection, please try again.");
        }
        return (T)result;
    }

    public <T> T promptChoiceTyped(String message, List<T> options, T defaultIfEmpty) {
        if (this.isAcceptDefaults()) {
            return defaultIfEmpty;
        }
        if (options == null || options.isEmpty()) {
            throw new IllegalArgumentException("promptChoice() Cannot ask user to select from a list of nothing. Ensure you have values in your options list.");
        }
        if (options.size() == 1) {
            return options.get(0);
        }
        this.println(message);
        InvalidInput result = InvalidInput.INSTANCE;
        while (result instanceof InvalidInput) {
            int count = 1;
            this.println();
            for (T entry : options) {
                if (entry != null && entry.equals(defaultIfEmpty)) {
                    this.print(ShellColor.BOLD, "  " + count + " - [" + entry + "]");
                } else if (entry != null) {
                    this.print("  " + count + " - [" + entry + "]");
                } else if (defaultIfEmpty == null) {
                    this.print(ShellColor.BOLD, "  " + count + " - (none)");
                }
                if (entry == defaultIfEmpty || entry != null && entry.equals(defaultIfEmpty)) {
                    this.print("*");
                }
                this.println();
                ++count;
            }
            this.println();
            int input = this.prompt("Choose an option by typing the number of the selection " + this.renderColor(ShellColor.BOLD, "[*-default] "), Integer.class, 0) - 1;
            if (input >= 0 && input < options.size()) {
                result = options.get(input);
                continue;
            }
            if (input == -1) {
                result = defaultIfEmpty;
                continue;
            }
            this.println("Invalid selection, please try again.");
        }
        return (T)result;
    }

    public <T> T promptChoice(String message, Map<String, T> options) {
        this.println(message);
        ArrayList<Map.Entry<String, T>> entries = new ArrayList<Map.Entry<String, T>>();
        entries.addAll(options.entrySet());
        InvalidInput result = InvalidInput.INSTANCE;
        while (result instanceof InvalidInput) {
            int n;
            int count = 1;
            this.println();
            for (Map.Entry entry : entries) {
                this.println("  " + count + " - [" + (String)entry.getKey() + "]");
                ++count;
            }
            this.println();
            String input = this.prompt("Choose an option by typing the name or number of the selection: ");
            if (options.containsKey(input)) {
                result = options.get(input);
                continue;
            }
            if (!input.matches("[0-9]+") || (n = Integer.parseInt(input)) <= 0 || n > options.size()) continue;
            result = ((Map.Entry)entries.get(n - 1)).getValue();
        }
        return (T)result;
    }

    public String promptCommon(String message, PromptType type) {
        String input;
        while (!type.matches(input = this.prompt(message))) {
        }
        input = this.getPromptTypeConverter().convert(type, input);
        return input;
    }

    public String promptCommon(String message, PromptType type, String defaultIfEmpty) {
        String input;
        if (this.isAcceptDefaults()) {
            return defaultIfEmpty;
        }
        if (!type.matches(defaultIfEmpty)) {
            throw new IllegalArgumentException("Default value [" + defaultIfEmpty + "] is not a valid match for the given prompt type [" + type.name() + "]");
        }
        do {
            String query = " [" + defaultIfEmpty + "] ";
            input = this.prompt(message + query);
            if (input != null && !input.isEmpty()) continue;
            input = defaultIfEmpty;
        } while (!type.matches(input));
        input = this.getPromptTypeConverter().convert(type, input);
        return input;
    }

    public <T extends Enum<T>> T promptEnum(String message, Class<T> type) {
        String value = "";
        while (value == null || value.trim().isEmpty()) {
            value = this.promptWithCompleter(message, new CompleterAdaptor((CommandCompleter)new EnumCompleter(type)));
        }
        Enum result = Enums.valueOf(type, value.trim());
        if (result == null) {
            result = (Enum)this.promptChoiceTyped(message, Arrays.asList(type.getEnumConstants()));
        }
        return (T)result;
    }

    public <T extends Enum<T>> T promptEnum(String message, Class<T> type, T defaultIfEmpty) {
        Object result;
        if (this.isAcceptDefaults()) {
            return defaultIfEmpty;
        }
        do {
            String query = " [" + defaultIfEmpty + "] ";
            String value = this.promptWithCompleter(message + query, new CompleterAdaptor((CommandCompleter)new EnumCompleter(type)));
            if (value == null || value.trim().isEmpty()) {
                result = defaultIfEmpty;
                continue;
            }
            result = Enums.valueOf(type, value.trim());
            if (result != null) continue;
            result = (Enum)this.promptChoiceTyped(message + query, Arrays.asList(type.getEnumConstants()), defaultIfEmpty);
        } while (result == null);
        return result;
    }

    public FileResource<?> promptFile(String message) {
        String path = "";
        while (path == null || path.trim().isEmpty()) {
            path = this.promptWithCompleter(message, new FileNameCompleter());
        }
        path = Files.canonicalize((String)path);
        Resource resource = this.getResourceFactory().getResourceFrom(new File(path));
        if (resource instanceof FileResource) {
            return (FileResource)resource;
        }
        return null;
    }

    public FileResource<?> promptFile(String message, FileResource<?> defaultIfEmpty) {
        if (this.isAcceptDefaults()) {
            return defaultIfEmpty;
        }
        Object result = defaultIfEmpty;
        String query = " [ .../" + defaultIfEmpty.getName() + "] ";
        String path = this.promptWithCompleter(message + query, new FileNameCompleter());
        if (path != null && !path.trim().isEmpty()) {
            path = Files.canonicalize((String)path);
            Resource resource = this.getResourceFactory().getResourceFrom(new File(path));
            result = resource instanceof FileResource ? (FileResource)resource : null;
        }
        return result;
    }

    public String promptRegex(String message, String regex) {
        String input;
        while (!(input = this.prompt(message)).matches(regex)) {
        }
        return input;
    }

    public String promptRegex(String message, String pattern, String defaultIfEmpty) {
        String input;
        if (this.isAcceptDefaults()) {
            return defaultIfEmpty;
        }
        if (!defaultIfEmpty.matches(pattern)) {
            throw new IllegalArgumentException("Default value [" + defaultIfEmpty + "] does not match required pattern [" + pattern + "]");
        }
        do {
            String query = " [" + defaultIfEmpty + "] ";
            input = this.prompt(message + query);
            if (!"".equals(input.trim())) continue;
            input = defaultIfEmpty;
        } while (!input.matches(pattern));
        return input;
    }

    public String promptSecret(String message, String defaultIfEmpty) {
        if (this.isAcceptDefaults()) {
            return defaultIfEmpty;
        }
        String secret = this.promptSecret(message + " [ENTER for default]");
        if (secret == null || secret.trim().isEmpty()) {
            secret = defaultIfEmpty;
        }
        return secret;
    }
}

