/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import javax.resource.ResourceException;

/**
 * A marker interface for connections that support the lazy connection
 * association optimization.
 */
public interface DissociatableManagedConnection
{
   /**
	 * Invoked by the application server to dissociate the managed connection
	 * from all handles.
	 * 
	 * @throws ResourceException for any error
	 * @throws ResourceAdapterInternalException for an internal error in the
	 *            resource adapter
	 * @throws IllegalStateException if the state cannot be cleaned up, e.g. a
	 *            transaction is in progress
	 */
   void dissociateConnections() throws ResourceException;
}