/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.query.list;

import java.util.Properties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.wizards.query.AbstractQueryWizardView;
import org.jboss.tools.common.model.ui.wizards.query.list.CheckObject;
import org.jboss.tools.common.model.ui.wizards.query.list.CheckTreeProvider;
import org.jboss.tools.common.model.ui.wizards.query.list.TreeItemSelectionManager;

public abstract class AbstractTreeWizardView
extends AbstractQueryWizardView {
    protected CommandBar allBar = new CommandBar();
    protected TreeViewer treeViewer;
    protected CheckTreeProvider provider = new CheckTreeProvider();
    protected TreeItemSelectionManager treeSelectionManager;
    protected String[][] vs = new String[0][];
    CheckObject object = new CheckObject(null, new String[]{"", "yes"});
    int expandingLevel = 2;

    public AbstractTreeWizardView() {
        this.createAllBar();
    }

    public void dispose() {
        super.dispose();
        if (this.allBar != null) {
            this.allBar.dispose();
        }
        this.allBar = null;
    }

    protected abstract String[] getActions();

    protected void createAllBar() {
        this.allBar.getLayout().direction = 512;
        this.allBar.setCommands(this.getActions());
        this.allBar.addCommandBarListener(this);
    }

    public void setObject(Object data) {
        super.setObject(data);
        Properties p = (Properties)data;
        this.vs = (String[][])p.get("data");
        String s = p.getProperty("expandingLevel");
        if (s != null && s.length() > 0) {
            try {
                this.expandingLevel = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        this.makeObject();
    }

    void makeObject() {
        this.object = new CheckObject(null, new String[]{"", "no"});
        this.provider.setObject(this.object);
        int i = 0;
        while (i < this.vs.length) {
            String path = this.vs[i][0];
            CheckObject c = this.object.getByPath(path);
            if (c != null) {
                c.objectData = this.vs[i];
            } else {
                CheckObject checkObject = this.create(this.vs[i]);
            }
            ++i;
        }
    }

    private CheckObject create(String[] data) {
        CheckObject p;
        String path = data[0];
        int s = path.lastIndexOf(47);
        String parentPath = path.substring(0, s);
        CheckObject checkObject = p = parentPath.length() == 0 ? this.object : this.object.getByPath(parentPath);
        if (p == null) {
            p = this.create(new String[]{parentPath, "no"});
        }
        CheckObject c = new CheckObject(p, data);
        p.addChild(c);
        return c;
    }

    public Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        this.treeViewer = new TreeViewer(composite, 2848);
        this.treeViewer.setContentProvider((IContentProvider)this.provider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.provider);
        this.treeViewer.setInput((Object)this);
        this.provider.getChildren(this);
        Control tc = this.treeViewer.getControl();
        tc.setLayoutData((Object)new GridData(1808));
        this.initTree();
        this.treeSelectionManager = new TreeItemSelectionManager(this.treeViewer, new Flipper());
        this.treeViewer.expandToLevel(this.expandingLevel);
        Control bc = this.allBar.createControl(composite);
        bc.setLayoutData((Object)new GridData(1040));
        return composite;
    }

    private void initTree() {
        Tree tree = this.treeViewer.getTree();
        TreeItem[] is = tree.getItems();
        int i = 0;
        while (i < is.length) {
            Object d = is[i].getData();
            if (d instanceof CheckObject) {
                CheckObject o = (CheckObject)d;
                is[i].setChecked(!o.isDisabled());
            }
            ++i;
        }
    }

    public void action(String command) {
        if (CANCEL.equals(command) || OK.equals(command) || HELP.equals(command)) {
            super.action(command);
        } else {
            this.stopEditing();
            this.internalAction(command);
        }
    }

    protected abstract void internalAction(String var1);

    protected void enableAll() {
        this.enableHierarchy(this.object);
        this.treeSelectionManager.update();
        this.treeViewer.refresh();
    }

    private void enableHierarchy(CheckObject o) {
        CheckObject[] os = o.getChildren();
        int i = 0;
        while (i < os.length) {
            os[i].setEnabled(true);
            this.enableHierarchy(os[i]);
            ++i;
        }
    }

    protected void disableAll() {
        CheckObject[] os = this.object.getChildren();
        int i = 0;
        while (i < os.length) {
            os[i].setEnabled(false);
            ++i;
        }
        this.treeSelectionManager.update();
        this.treeViewer.refresh();
    }

    class Flipper
    implements TreeItemSelectionManager.Listener {
        Flipper() {
        }

        public void flip(TreeItem item) {
            if (item == null) {
                return;
            }
            CheckObject w = (CheckObject)item.getData();
            w.flip();
            AbstractTreeWizardView.this.treeViewer.refresh((Object)w);
        }

        public boolean isSelected(Object data) {
            if (data instanceof CheckObject) {
                CheckObject o = (CheckObject)data;
                return !o.isDisabled();
            }
            return false;
        }
    }
}

