/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates.configuration;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.templates.configuration.MetaConfiguration;
import org.jboss.tools.common.model.ui.templates.configuration.MetaConfigurationManager;
import org.jboss.tools.common.model.ui.templates.model.MetaClassTemplate;

public class MetaClassTemplateHelper {
    public static MetaClassTemplateHelper instance = new MetaClassTemplateHelper();

    public MetaConfiguration getCurrentConfiguration(IProject project) {
        MetaConfigurationManager m = MetaConfigurationManager.getInstance();
        if (this.isProjectOverrideTemplates()) {
            return m.getProjectConfiguration(project);
        }
        return m.getGlobalConfiguration();
    }

    public MetaClassTemplate getMetaTemplate(IProject project, String publicId, String axis) {
        MetaConfiguration configuration;
        MetaClassTemplate template = null;
        if (project != null && (configuration = this.getCurrentConfiguration(project)) != null) {
            template = configuration.getMetaTemplate(publicId, axis);
        }
        return template;
    }

    public String getSuperClassName(IProject project, String publicId, String axis) {
        MetaClassTemplate template = this.getMetaTemplate(project, publicId, axis);
        return template != null ? template.getSuperClass().getValue() : null;
    }

    public String[] getInterfacesName(IProject project, String publicId, String axis) {
        MetaClassTemplate template = this.getMetaTemplate(project, publicId, axis);
        return template != null ? template.getInterfaces().getValues() : null;
    }

    public boolean isProjectOverrideTemplates() {
        QualifiedName qn = new QualifiedName("org.jboss.tools.common.model.ui.templates", "org.jboss.tools.common.model.ui.templates.projectOverriveTemplates");
        try {
            String projectOverride = ResourcesPlugin.getWorkspace().getRoot().getPersistentProperty(qn);
            return projectOverride != null && Boolean.parseBoolean(projectOverride);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void setProjectOverrideTemplates(boolean b) {
        QualifiedName qn = new QualifiedName("org.jboss.tools.common.model.ui.templates", "org.jboss.tools.common.model.ui.templates.projectOverriveTemplates");
        try {
            ResourcesPlugin.getWorkspace().getRoot().setPersistentProperty(qn, "" + b);
        }
        catch (CoreException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

