/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.navigator;

import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class NavigatorLabelProvider
extends LabelProvider
implements IColorProvider {
    public String getText(Object element) {
        String result = "";
        if (element != null) {
            if (element instanceof XModelObject) {
                XModelObject o = (XModelObject)element;
                result = o.getPresentationString();
                result = this.applyModification(o, result);
            } else {
                result = element.toString();
            }
        }
        return result == null ? "" : result;
    }

    protected String applyModification(XModelObject o, String text) {
        if (o.getFileType() == 1 && o.isModified()) {
            text = String.valueOf(text) + "*";
        }
        return text;
    }

    public Image getImage(Object element) {
        Image result = null;
        if (element instanceof XModelObject) {
            result = EclipseResourceUtil.getImage((XModelObject)((XModelObject)element));
        }
        return result;
    }

    public Color getForeground(Object element) {
        if (element instanceof XModelObject) {
            XModelObject o = (XModelObject)element;
            if (this.isLink(o)) {
                return Display.getDefault().getSystemColor(9);
            }
            if (this.hasErrors(o)) {
                return Display.getDefault().getSystemColor(3);
            }
            if (this.hasParentFileErrors(o)) {
                return Display.getDefault().getSystemColor(15);
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    private boolean isLink(XModelObject obj) {
        return "true".equals(obj.get("overlapped"));
    }

    private boolean hasErrors(XModelObject o) {
        return o != null && "yes".equals(o.get("_hasErrors_"));
    }

    private boolean hasParentFileErrors(XModelObject o) {
        if (o.getFileType() != 0) {
            return false;
        }
        XModelObject p = o.getParent();
        while (p != null && p.getFileType() != 1) {
            p = p.getParent();
        }
        return this.hasErrors(p);
    }
}

