/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.forms.IForm;
import org.jboss.tools.common.model.ui.forms.IFormPage;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;

public class DefaultFormPage
implements IFormPage,
PaintListener {
    public static final String IMG_FORM_BANNER = "form_banner.gif";
    private ISelectionProvider selectionProvider;
    protected IWidgetSettings settings;
    private int HEADER_H_GAP = 10;
    private int HEADER_V_GAP = 5;
    protected Color headingBackground;
    protected Color headingForeground = Display.getDefault().getSystemColor(9);
    protected IForm form;
    protected Control control;
    protected Image image;
    protected Font titleFont;
    protected String label;
    protected String title;
    private int widthHint = -1;
    private int heightHint = -1;

    public DefaultFormPage() {
        this.image = ModelUIImages.getImage(IMG_FORM_BANNER);
    }

    public DefaultFormPage(IForm form) {
        this.form = form;
        this.image = ModelUIImages.getImage(IMG_FORM_BANNER);
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.form != null) {
            return this.form.getHeadingText();
        }
        return "Null";
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        if (this.form != null) {
            return this.form.getHeadingText();
        }
        return "Null";
    }

    public boolean becomesInvisible(IFormPage newPage) {
        return true;
    }

    public void becomesVisible(IFormPage previousPage) {
    }

    public Control createFormControl(Composite parent, IWidgetSettings settings) {
        Composite control;
        if (this.form == null) {
            control = new Composite(parent, 0);
            settings.setupControl((Control)control);
        } else {
            control = this.form.createControl(parent, settings);
        }
        return control;
    }

    public Control createControl(Composite parent) {
        this.settings = WhiteSettings.getWhite();
        this.titleFont = this.settings.getFont("Label.Font.Title");
        Composite composite = new Composite(parent, 0);
        this.settings.setupControl((Control)composite);
        composite.addPaintListener((PaintListener)this);
        composite.setLayout((Layout)new FormLayout());
        composite.setMenu(parent.getMenu());
        Control formControl = this.createFormControl(composite, this.settings);
        GridData gd = new GridData(1536);
        formControl.setLayoutData((Object)gd);
        this.control = composite;
        return this.control;
    }

    public Control getControl() {
        return this.control;
    }

    public boolean isSource() {
        return false;
    }

    public boolean isVisible() {
        return false;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    private int getTitleHeight() {
        int imageHeight = 0;
        if (this.image != null && !SWT.getPlatform().equals("motif")) {
            imageHeight = this.image.getBounds().height;
        }
        int height = this.getFontHeight() + 2 * this.HEADER_V_GAP;
        return Math.max(height, imageHeight);
    }

    private int getFontHeight() {
        GC gc = new GC((Drawable)this.control);
        FontMetrics fm = gc.getFontMetrics();
        int fontHeight = fm.getHeight();
        gc.dispose();
        return fontHeight;
    }

    private void paint(Control form, GC gc) {
        if (this.image != null) {
            this.paintWithImage(form, gc);
        } else {
            gc.setBackground(this.settings.getColor("Composite.Background"));
            gc.setForeground(this.settings.getColor("Composite.Foreground"));
        }
        gc.setFont(this.titleFont);
        gc.drawText(this.getTitle(), this.HEADER_H_GAP, this.HEADER_V_GAP, true);
    }

    private void paintWithImage(Control form, GC gc) {
        Rectangle bounds = form.getBounds();
        if (this.headingBackground != null) {
            gc.setBackground(this.headingBackground);
            gc.fillRectangle(0, 0, bounds.width, this.getTitleHeight());
        }
        SWT.getPlatform().equals("motif");
        Color fg = this.headingForeground != null ? this.headingForeground : this.settings.getColor("Composite.Foreground");
        FormToolkit t = this.settings.getToolkit(form.getDisplay());
        if (t != null && t.getColors().getColor("org.eclipse.ui.forms.TITLE") != null) {
            fg = t.getColors().getColor("org.eclipse.ui.forms.TITLE");
        }
        gc.setForeground(fg);
    }

    public final void paintControl(PaintEvent event) {
        this.paint((Control)event.widget, event.gc);
    }

    public void initialize(Object model) {
    }

    public void commitChanges(boolean onSave) {
    }

    public void expandTo(Object object) {
    }

    public void update() {
    }

    public ISelectionProvider getSelectionProvider() {
        return this.selectionProvider;
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider;
    }

    public void dispose() {
        if (this.control != null) {
            this.control.dispose();
        }
        this.control = null;
    }

    class FormLayout
    extends Layout {
        FormLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            if (wHint != -1 && hHint != -1) {
                return new Point(wHint, hHint);
            }
            Control client = composite.getChildren()[0];
            Point csize = client.computeSize(DefaultFormPage.this.widthHint, DefaultFormPage.this.heightHint, flushCache);
            csize.y += DefaultFormPage.this.getTitleHeight();
            return csize;
        }

        protected void layout(Composite composite, boolean flushCache) {
            Rectangle r = composite.getClientArea();
            int th = DefaultFormPage.this.getTitleHeight();
            composite.getChildren()[0].setBounds(r.x, r.y + th, r.width, r.height - th);
        }
    }
}

