/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.MethodNotImplementedException;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.widgets.BorderedControl;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.ScrolledComposite;
import org.jboss.tools.common.model.ui.widgets.border.Border;

public class StringFieldEditor
extends ExtendedFieldEditor {
    public static final int VALIDATE_ON_KEY_STROKE = 0;
    public static final int VALIDATE_ON_FOCUS_LOST = 1;
    public static int UNLIMITED = -1;
    private boolean isValid;
    private String oldValue;
    private Text textField;
    private Control textControl;
    private int charCapacity = UNLIMITED;
    private int textLimit = UNLIMITED;
    private String error;
    private boolean emptyStringAllowed = true;
    private int validateStrategy = 0;

    public StringFieldEditor() {
    }

    public StringFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    protected void adjustForNumColumns(int numColumns) {
        GridData gd = (GridData)this.textField.getLayoutData();
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = gd.horizontalSpan == 1;
    }

    protected boolean validate() {
        boolean result = false;
        if (this.emptyStringAllowed) {
            result = true;
        }
        if (this.textField == null) {
            result = false;
            return result;
        }
        String txt = this.textField.getText();
        result = txt == null ? false : txt.trim().length() > 0 || this.emptyStringAllowed;
        boolean bl = result = result && this.doValidate();
        if (result) {
            this.clearErrorMessage();
        } else {
            this.showErrorMessage(this.error);
        }
        return result;
    }

    protected boolean doValidate() {
        return true;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        this.createTextControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns - 1;
        if (this.charCapacity != UNLIMITED) {
            GC gc = new GC((Drawable)this.textField);
            try {
                Point extent = gc.textExtent("X");
                gd.widthHint = this.charCapacity * extent.x;
            }
            finally {
                gc.dispose();
            }
        } else {
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
        }
        this.textField.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        throw new MethodNotImplementedException();
    }

    protected void doLoadDefault() {
        throw new MethodNotImplementedException();
    }

    protected void doStore() {
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.textField.getText());
    }

    public int getNumberOfControls() {
        return 2;
    }

    public String getStringValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return this.getPreferenceStore().getString(this.getPreferenceName());
    }

    protected Text getTextField() {
        return this.textField;
    }

    protected Control getTextControl() {
        return this.textControl;
    }

    public Control createTextControl(Composite parent) {
        if (this.textField == null) {
            int style = this.getSettings().getStyle("Text.Style");
            if (style == -1) {
                style = 0;
            }
            Color fg = this.getSettings().getColor("Text.Foreground");
            Font font = this.getSettings().getFont("Text.Font");
            Border border = this.getSettings().getBorder("Text.Border");
            boolean readOnly = this.isAlwaysReadOnly();
            if (border != null) {
                if (readOnly) {
                    style |= 8;
                }
                BorderedControl borderedControl = new BorderedControl(parent, 0, border);
                this.textField = new Text((Composite)borderedControl, style);
                this.textControl = borderedControl;
            } else {
                int style2 = 2048;
                if (readOnly) {
                    style2 |= 8;
                }
                this.textField = new Text(parent, style2);
                this.textControl = this.textField;
            }
            this.textField.setFont(font);
            this.textField.setForeground(fg);
            switch (this.validateStrategy) {
                case 0: {
                    this.textField.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent e) {
                            StringFieldEditor.this.valueChanged();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            StringFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                case 1: {
                    this.textField.addKeyListener((KeyListener)new KeyAdapter(){

                        public void keyPressed(KeyEvent e) {
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    this.textField.addFocusListener((FocusListener)new FocusAdapter(){

                        public void focusGained(FocusEvent e) {
                            StringFieldEditor.this.refreshValidState();
                        }

                        public void focusLost(FocusEvent e) {
                            StringFieldEditor.this.valueChanged();
                            StringFieldEditor.this.clearErrorMessage();
                        }
                    });
                    break;
                }
                default: {
                    Assert.isTrue((boolean)false, (String)"Unknown validate strategy");
                }
            }
            this.textField.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    StringFieldEditor.this.textField = null;
                }
            });
            if (this.textLimit > 0) {
                this.textField.setTextLimit(this.textLimit);
            }
            this.addContentAssist(this.textField);
        } else {
            this.checkParent(this.textControl, parent);
        }
        this.textField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (StringFieldEditor.this.textField == null || StringFieldEditor.this.textField.isDisposed()) {
                    return;
                }
                ScrolledComposite.scrollToVisible((Control)StringFieldEditor.this.textField, new Rectangle(0, 0, ((StringFieldEditor)StringFieldEditor.this).textField.getBounds().width, ((StringFieldEditor)StringFieldEditor.this).textField.getBounds().height));
            }

            public void focusLost(FocusEvent e) {
            }
        });
        return this.textControl;
    }

    protected void addContentAssist(Text text) {
    }

    protected boolean isAlwaysReadOnly() {
        return false;
    }

    public boolean isEmptyStringAllowed() {
        return this.emptyStringAllowed;
    }

    public boolean isValid() {
        return this.isValid;
    }

    protected void refreshValidState() {
        this.isValid = this.validate();
    }

    public void setEmptyStringAllowed(boolean b) {
        this.emptyStringAllowed = b;
    }

    public void setErrorMessage(String message) {
        this.error = message;
    }

    public void setFocus() {
        if (this.textField != null) {
            this.textField.setSelection(0, this.textField.getText().length());
            this.textField.setFocus();
        }
    }

    public void setStringValue(String value) {
        if (this.textField != null) {
            if (value == null) {
                value = "";
            }
            this.oldValue = this.textField.getText();
            if (!this.oldValue.equals(value)) {
                String ov = this.oldValue;
                Point p = this.textField.getSelection();
                this.textField.setText(value);
                int i = this.findPosition(ov, value, p.x);
                this.textField.setSelection(i);
                this.valueChanged();
            }
        }
    }

    private int findPosition(String ov, String nv, int p) {
        if (p == ov.length() || p < 0) {
            return nv.length();
        }
        int i = 0;
        while (i < p) {
            if (i >= ov.length() || i >= nv.length()) {
                return nv.length();
            }
            if (ov.charAt(i) != nv.charAt(i)) {
                return i;
            }
            ++i;
        }
        return p;
    }

    public void setTextLimit(int limit) {
        this.textLimit = limit;
        if (this.textField != null) {
            this.textField.setTextLimit(limit);
        }
    }

    public void setValidateStrategy(int value) {
        Assert.isTrue((value == 1 || value == 0 ? 1 : 0) != 0);
        this.validateStrategy = value;
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        boolean oldState = this.isValid;
        this.refreshValidState();
        if (this.isValid != oldState) {
            this.fireStateChanged("field_editor_is_valid", oldState, this.isValid);
        }
        if (this.textField == null) {
            return;
        }
        String newValue = this.textField.getText();
        if (!newValue.equals(this.oldValue)) {
            this.fireValueChanged("field_editor_value", this.oldValue, newValue);
            if (this.textField == null) {
                return;
            }
            this.oldValue = this.textField.getText();
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setTextControlEnabled(enabled);
        this.updateErrorState();
    }

    protected void setTextControlEnabled(boolean enabled) {
        Control c = this.getTextControl();
        if (c != null && !c.isDisposed()) {
            Text text = this.getTextField();
            if (text != null && !text.isDisposed()) {
                text.setEditable(enabled);
            } else {
                boolean e = this.isAlwaysReadOnly();
                c.setEnabled(enabled || e);
            }
        }
    }

    public void cut() {
        if (this.textField != null && this.textField.isFocusControl() && this.isEnabled()) {
            this.textField.cut();
            this.valueChanged();
        }
    }

    public void copy() {
        if (this.textField != null && this.textField.isFocusControl()) {
            this.textField.copy();
        }
    }

    public void paste() {
        if (this.textField != null && this.textField.isFocusControl() && this.isEnabled()) {
            this.textField.paste();
            this.valueChanged();
        }
    }

    public void delete() {
    }
}

