/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.action;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.actions.OpenWithMenu;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XActionList;
import org.jboss.tools.common.meta.key.WizardKeys;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.XModelObjectAction;
import org.jboss.tools.common.model.ui.action.XModelObjectActionItem;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class XModelObjectActionList
extends XModelObjectActionItem {
    protected XActionList list;

    public XModelObjectActionList(XActionList list, XModelObject object, XModelObject[] targets, Object environment) {
        super((XActionItem)list, object, targets, environment);
        this.list = list;
    }

    public void createMenu(Menu parent) {
        if (this.list.getGroupFactor() == 0) {
            if (parent.getItems().length > 0 && parent.getItems()[parent.getItems().length - 1].getStyle() != 2) {
                new MenuItem(parent, 2);
            }
            this.fillMenu(parent);
        } else {
            MenuItem item = new MenuItem(parent, 64);
            String displayName = WizardKeys.getMenuItemDisplayName((XActionItem)this.list, this.object == null ? null : this.object.getModelEntity());
            item.setText(displayName);
            Menu menu = new Menu(item);
            item.setMenu(menu);
            this.fillMenu(menu);
            this.removeLastSeparator(menu);
            if (menu.getItems().length == 0) {
                item.dispose();
            } else {
                menu.setVisible(true);
            }
        }
    }

    public Menu createMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.setShell(parent.getShell());
        this.fillMenu(menu);
        this.removeLastSeparator(menu);
        return menu;
    }

    public void removeLastSeparator(Menu menu) {
        int c = menu.getItems().length - 1;
        if (c >= 0 && menu.getItems()[c].getStyle() == 2) {
            menu.getItems()[c].dispose();
        }
    }

    public void fillMenu(Menu menu) {
        XActionItem[] is = this.list.getActionItems();
        int i = 0;
        while (i < is.length) {
            XModelObjectActionItem a;
            if (is[i] instanceof XAction) {
                XAction action = (XAction)is[i];
                a = new XModelObjectAction(action, this.object, this.targets, this.environment);
                a.setShell(this.shell);
                ((XModelObjectAction)a).createMenuItem(menu);
            } else {
                XActionList l = (XActionList)is[i];
                if ("OpenWith".equals(l.getName())) {
                    IResource resource;
                    if (this.object.getFileType() == 1 && (this.targets == null || this.targets.length < 2) && (resource = EclipseResourceUtil.getResource((XModelObject)this.object)) != null && resource.getType() == 1) {
                        String displayName = WizardKeys.getMenuItemDisplayName((XActionItem)l, this.object == null ? null : this.object.getModelEntity());
                        MenuItem item = new MenuItem(menu, 64);
                        item.setText(displayName);
                        Menu subMenu = new Menu(item);
                        OpenWithMenu openMenu = new OpenWithMenu(ModelUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IAdaptable)resource);
                        openMenu.fill(subMenu, 0);
                        item.setMenu(subMenu);
                    }
                } else {
                    a = new XModelObjectActionList(l, this.object, this.targets, this.environment);
                    a.setShell(this.shell);
                    ((XModelObjectActionList)a).createMenu(menu);
                }
            }
            ++i;
        }
    }
}

