/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.key;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XActionItem;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.key.KeyLoader;

public class WizardKeys {
    private static Properties keys;
    private static Properties labels;
    private static Properties common;
    private static Set<String> LOWER_CASE_WORDS;
    private static Set<String> UPPER_CASE_WORDS;

    static {
        int i;
        labels = keys = new Properties();
        common = keys;
        Locale locale = Locale.getDefault();
        String localeString = locale.toString();
        while (true) {
            WizardKeys.addNew(keys, KeyLoader.load(localeString));
            if (localeString.length() == 0) break;
            i = localeString.indexOf(95);
            localeString = i < 0 ? "" : localeString.substring(0, i);
        }
        LOWER_CASE_WORDS = new HashSet<String>();
        UPPER_CASE_WORDS = new HashSet<String>();
        String[] lcw = new String[]{"the", "web.xml", "for"};
        String[] ucw = new String[]{"tld", "uri", "jsp", "html", "url", "jsf", "xml", "id", "jms", "esb", "ftp", "jbr", "fs", "mep"};
        i = 0;
        while (i < lcw.length) {
            LOWER_CASE_WORDS.add(lcw[i]);
            ++i;
        }
        i = 0;
        while (i < ucw.length) {
            UPPER_CASE_WORDS.add(ucw[i]);
            ++i;
        }
    }

    private static void addNew(Properties target, Properties source) {
        Enumeration<Object> it = source.keys();
        while (it.hasMoreElements()) {
            String n = it.nextElement().toString();
            if (target.containsKey(n)) continue;
            target.setProperty(n, source.getProperty(n));
        }
    }

    public static String getHeader(String key) {
        if (key == null) {
            return null;
        }
        return keys.getProperty(String.valueOf(key) + ".WindowTitle");
    }

    public static String getTitle(String key) {
        if (key == null) {
            return null;
        }
        return keys.getProperty(String.valueOf(key) + ".Title");
    }

    public static String getMessage(String key) {
        if (key == null) {
            return null;
        }
        return keys.getProperty(String.valueOf(key) + ".Message");
    }

    public static String getLabelText(String entity, String attribute) {
        String key = entity + "." + attribute.replace(' ', '_');
        return keys.getProperty(key);
    }

    public static String getLabelText(String key) {
        return key == null ? null : labels.getProperty(key);
    }

    public static String getString(String key) {
        if (key != null) {
            if (common.getProperty(key) != null) {
                return common.getProperty(key);
            }
            return null;
        }
        return "@NULL_KEY@";
    }

    public static String getAttributeDisplayName(XAttributeData a, boolean build) {
        String d = WizardKeys.getAttributeDisplayName(a);
        return d != null || !build ? d : WizardKeys.toDisplayName(a.getAttribute().getName());
    }

    public static String getAttributeDisplayName(XAttributeData a) {
        return WizardKeys.getAttributeDisplayName(a.getAttribute());
    }

    public static String getAttributeDisplayName(XAttribute a, boolean build) {
        String d = WizardKeys.getAttributeDisplayName(a);
        return d != null || !build ? d : WizardKeys.toDisplayName(a.getName());
    }

    public static String getAttributeDisplayName(XAttribute a) {
        String s = WizardKeys.getLabelText(a.getModelEntity().getName(), a.getName());
        if (s == null) {
            String labelText = String.valueOf(a.getModelEntity().getName()) + "_" + a.getName();
            s = WizardKeys.getLabelText(labelText);
        }
        if (s == null) {
            s = WizardKeys.getLabelText(a.getModelEntity().getModule(), a.getName());
        }
        return s;
    }

    public static String toDisplayName(String n) {
        if (n == null || n.length() == 0) {
            return "";
        }
        StringTokenizer st = new StringTokenizer(n, " -", true);
        StringBuffer sb = new StringBuffer();
        int k = st.countTokens();
        int i = 0;
        while (i < k) {
            String t = st.nextToken();
            if (UPPER_CASE_WORDS.contains(t)) {
                sb.append(t.toUpperCase());
            } else if (i > 0 && (t.length() < 3 || LOWER_CASE_WORDS.contains(t))) {
                sb.append(t);
            } else {
                sb.append(t.substring(0, 1).toUpperCase()).append(t.substring(1));
            }
            ++i;
        }
        return sb.toString();
    }

    public static String getMenuItemDisplayName(XActionItem item, XModelEntity entity) {
        String s = WizardKeys.getDisplayValue(item, entity, ".", ".menu");
        if (s != null) {
            return s;
        }
        return item.getDisplayName();
    }

    public static String getHeader(XActionItem item, XModelEntity entity) {
        String s = WizardKeys.getDisplayValue(item, entity, "_", ".WindowTitle");
        if (s != null) {
            return s;
        }
        return item.getDisplayName();
    }

    public static String getTitle(XActionItem item, XModelEntity entity) {
        String s = WizardKeys.getDisplayValue(item, entity, "_", ".Title");
        if (s != null) {
            return s;
        }
        return item.getDisplayName();
    }

    public static String getDisplayValue(XActionItem item, XModelEntity entity, String separator, String suffix) {
        String s;
        String key;
        if (entity != null) {
            key = String.valueOf(entity.getName()) + separator + item.getName() + suffix;
            s = keys.getProperty(key);
            if (s != null) {
                return s;
            }
            key = String.valueOf(entity.getModule()) + "." + item.getName() + suffix;
            s = keys.getProperty(key);
            if (s != null) {
                return s;
            }
        }
        if ((s = keys.getProperty(key = String.valueOf(item.getName()) + suffix)) != null) {
            return s;
        }
        return null;
    }

    public static String getVisualListValue(XAttribute attr, String value) {
        if (attr == null || value == null || value.length() == 0) {
            return value;
        }
        String keyPart = WizardKeys.toKey(value);
        String module = attr.getModelEntity().getModule();
        String key1 = String.valueOf(module) + "." + "lists." + keyPart;
        String result = WizardKeys.getString(key1);
        if (result != null) {
            return result;
        }
        String key2 = "lists." + keyPart;
        result = WizardKeys.getString(key2);
        if (result != null) {
            return result;
        }
        return value;
    }

    public static String toKey(String s) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '.' || Character.isJavaIdentifierPart(c)) {
                sb.append(c);
            } else {
                sb.append('_');
            }
            ++i;
        }
        return sb.toString();
    }
}

