/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Properties;
import org.jboss.tools.common.meta.XAdoptManager;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.meta.action.impl.handlers.HUtil;
import org.jboss.tools.common.meta.action.impl.handlers.PasteEnterNewNameSupport;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.ActionDeclinedException;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class PasteHandler
extends AbstractHandler {
    public static String IS_CANCELLED = "isCancelled";
    private static String[] attrs = new String[]{"attribute name", "yes", "entity name", "yes", "parameters", "no"};

    public PasteHandler() {
        this.data = new XEntityDataImpl[1];
    }

    @Override
    public XEntityData[] getEntityData(XModelObject object) {
        return this.getEntityData(object, 0);
    }

    protected XEntityData[] getEntityData(XModelObject object, int bi) {
        if (this.getBuffer(object).source(bi) == null) {
            return null;
        }
        ArrayList<String[]> a = new ArrayList<String[]>();
        a.add(new String[]{this.getEntityName(object, bi), "yes"});
        String an = this.getAttributeName(this.getEntityName(object, bi));
        if (an != null) {
            a.add(new String[]{an, "yes"});
        }
        int i = 0;
        while (i < attrs.length) {
            this.register(object, attrs[i], attrs[i + 1], a, bi);
            i += 2;
        }
        String[][] ds = new String[a.size()][];
        int i2 = 0;
        while (i2 < ds.length) {
            ds[i2] = a.get(i2);
            ++i2;
        }
        this.data[0] = XEntityDataImpl.create(ds);
        this.setDefaultData(object, bi);
        return this.data;
    }

    private void register(XModelObject o, String attr, String mandatory, ArrayList<String[]> list, int bi) {
        if (this.hasAttribute(o.getModel(), attr, bi)) {
            list.add(new String[]{attr, mandatory});
        }
    }

    @Override
    public void executeHandler(XModelObject object, Properties prop) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        boolean isDrop = prop != null && "true".equals(prop.getProperty("isDrop"));
        int bs = object.getModel().getModelBuffer().getSize();
        int i = 0;
        while (i < bs) {
            this.execute(object, i, isDrop, prop);
            if (prop != null && "true".equals(prop.getProperty(IS_CANCELLED))) {
                return;
            }
            ++i;
        }
    }

    protected void execute(XModelObject parent, int sourceIndex, boolean isDrop, Properties p) throws XModelException {
        XModelBuffer buffer = this.getBuffer(parent);
        boolean isParent = this.isParent(parent, buffer.copy(sourceIndex));
        if (isParent) {
            if (!this.prepaste(parent, sourceIndex)) {
                return;
            }
            if (!isDrop) {
                this.paste(parent, sourceIndex, p);
            } else {
                this.pasteOnDrop(parent, sourceIndex, p);
            }
        } else {
            this.drop(parent, buffer.source(sourceIndex), p);
        }
    }

    protected final void paste(XModelObject parent, int sourceIndex, Properties p) throws XModelException {
        boolean mustGenerate;
        XChild c;
        XModelObject source = this.getBuffer(parent).source(sourceIndex);
        XModelObject copy = this.getBuffer(parent).copy(sourceIndex);
        XModelObject existing = parent.getChildByPath(copy.getPathPart());
        if (existing != null && (c = parent.getModelEntity().getChild(existing.getModelEntity().getName())) != null && c.isRequired() && c.getMaxCount() == 1) {
            return;
        }
        String found = existing == null ? null : copy.getModelEntity().getRenderer().getTitle(copy);
        String entity = this.getEntityName(parent, sourceIndex);
        this.getEntityData(parent, sourceIndex);
        XAttributeData[] ad = this.data[0].getAttributeData();
        boolean bl = mustGenerate = found != null && this.mustGenerate(entity);
        if (!mustGenerate) {
            int i;
            int n = i = found == null ? 0 : PasteEnterNewNameSupport.run(parent, source, copy, this.data[0]);
            if (i != 0) {
                throw new ActionDeclinedException("Paste declined.");
            }
        }
        int j = 0;
        while (j < ad.length) {
            copy.setAttributeValue(ad[j].getAttribute().getName(), ad[j].getValue());
            ++j;
        }
        if (!mustGenerate) {
            XAttributeData a;
            String an = this.getAttributeName(this.getEntityName(parent, sourceIndex));
            XAttributeData xAttributeData = a = an == null ? null : HUtil.find(this.data, 0, an);
            if (a != null) {
                copy.setAttributeValue(an, a.getValue());
            }
        } else {
            this.generate(parent, copy, this.getAttributeName(entity));
        }
        copy = this.modify(copy.copy());
        DefaultCreateHandler.addCreatedObject(parent, copy, p);
        if (copy.isActive()) {
            this.onChildPasted(copy);
        }
    }

    private boolean prepaste(XModelObject parent, int sourceIndex) {
        XModelObject source = parent.getModel().getModelBuffer().source(sourceIndex);
        String entity = source.getModelEntity().getName();
        XChild c = parent.getModelEntity().getChild(entity);
        if (c == null || c.getMaxCount() > 1) {
            return true;
        }
        XModelObject co = parent.getChildByPath(source.getPathPart());
        if (co == null) {
            return true;
        }
        if (co == source) {
            if (sourceIndex == 0) {
                this.showUniqueMessae(parent, source);
            }
            return false;
        }
        String n = "<" + co.getModelEntity().getXMLSubPath() + ">";
        String message = MessageFormat.format("Replace existing element {0}?", n);
        ServiceDialog d = parent.getModel().getService();
        int q = d.showDialog("Paste", message, new String[]{ModelMessages.OK, ModelMessages.Cancel}, null, 0);
        if (q != 0) {
            return false;
        }
        DefaultRemoveHandler.removeFromParent(co);
        return true;
    }

    private void showUniqueMessae(XModelObject parent, XModelObject source) {
        ServiceDialog d = parent.getModel().getService();
        String message = MessageFormat.format("{0} may have only one {1}. You cannot add its copy.", DefaultCreateHandler.title(parent, true), source.getAttributeValue("element type"));
        d.showDialog(ModelMessages.WARNING, message, new String[]{SpecialWizardSupport.OK}, null, 2);
    }

    protected void onChildPasted(XModelObject child) {
    }

    protected void pasteOnDrop(XModelObject parent, int sourceIndex, Properties p) throws XModelException {
        this.paste(parent, sourceIndex, p);
    }

    protected final void drop(XModelObject parent, XModelObject source, Properties p) throws XModelException {
        XAdoptManager am = parent.getModelEntity().getAdoptManager();
        if (am != null) {
            am.adopt(parent, source, p);
        }
    }

    protected XModelObject modify(XModelObject c) {
        return c;
    }

    @Override
    public boolean isEnabled(XModelObject object) {
        XModelBuffer buffer = object.getModel().getModelBuffer();
        int bs = buffer.getSize();
        if (bs == 0 || object == null || !object.isObjectEditable()) {
            return false;
        }
        int i = 0;
        while (i < bs) {
            boolean b;
            XModelObject s = buffer.source(i);
            boolean bl = b = s != null && (this.isParent(object, s) || this.canAdopt(object, s));
            if (!b) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isParent(XModelObject p, XModelObject c) {
        return (c = c.copy(true, 0)) != null && p.getModelEntity().getChild(c.getModelEntity().getName()) != null;
    }

    protected boolean canAdopt(XModelObject target, XModelObject bullet) {
        XAdoptManager am = target.getModelEntity().getAdoptManager();
        return am != null && am.isAdoptable(target, bullet);
    }

    protected String getEntityName(XModelObject object, int i) {
        String entity = this.action.getProperty("entity");
        if (entity != null) {
            return entity;
        }
        return this.getBuffer(object).source(i).getModelEntity().getName();
    }

    protected String getAttributeName(String entity) {
        XModelEntity e = XModelMetaDataImpl.getInstance().getEntity(entity);
        if (e.getAttribute(XModelObjectLoaderUtil.ATTR_ID_NAME) != null) {
            return XModelObjectLoaderUtil.ATTR_ID_NAME;
        }
        XAttribute[] as = e.getAttributes();
        int i = 0;
        while (i < as.length) {
            if ("true".equals(as[i].getProperty("id"))) {
                return as[i].getName();
            }
            ++i;
        }
        if (e.getAttribute("name") != null) {
            return "name";
        }
        return null;
    }

    protected boolean mustGenerate(String entity) {
        XModelEntity e = XModelMetaDataImpl.getInstance().getEntity(entity);
        if (e.getAttribute(XModelObjectLoaderUtil.ATTR_ID_NAME) != null) {
            return true;
        }
        XAttribute[] as = e.getAttributes();
        int i = 0;
        while (i < as.length) {
            if ("true".equals(as[i].getProperty("id")) && "true".equals(as[i].getProperty("generate"))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected int generate(XModelObject parent, XModelObject copy, String attr) {
        String v = copy.getAttributeValue(attr);
        while (v.length() > 0 && Character.isDigit(v.charAt(v.length() - 1))) {
            v = v.substring(0, v.length() - 1);
        }
        int k = 1;
        String pp = copy.getPathPart();
        while (parent.getChildByPath(pp) != null) {
            String ppn;
            copy.setAttributeValue(attr, String.valueOf(v) + k);
            pp = ppn = copy.getPathPart();
            ++k;
        }
        return 0;
    }

    protected boolean hasAttribute(XModel model, String attr, int bi) {
        return model.getMetaData().getEntity(this.getEntityName(model.getRoot(), bi)).getAttribute(attr) != null;
    }

    @Override
    public void setDefaultData(XModelObject object) {
        this.setDefaultData(object, 0);
    }

    public void setDefaultData(XModelObject object, int bi) {
        if (!this.isEnabled(object)) {
            return;
        }
        XModelObject c = this.getBuffer(object).copy(bi);
        XAttributeData[] ad = this.data[0].getAttributeData();
        int i = 0;
        while (i < ad.length) {
            ad[i].setValue(c.getAttributeValue(ad[i].getAttribute().getName()));
            ++i;
        }
    }

    @Override
    public void setData(XEntityData[] data) {
    }

    private XModelBuffer getBuffer(XModelObject o) {
        return o.getModel().getModelBuffer();
    }

    @Override
    public boolean isEnabled(XModelObject object, XModelObject[] objects) {
        return (objects == null || objects.length == 1) && this.isEnabled(object);
    }
}

