/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl.handlers;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.action.impl.handlers.HUtil;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.util.OSHelper;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class OpenWithHelper {
    static String EDITORS = "%Options%/External Programs";

    static String getFileName(XModelObject object) {
        ArrayList<String> l = new ArrayList<String>();
        XModelObject o = object;
        while (o != null) {
            int i = o.getFileType();
            if (i == 1) {
                l.add(FileAnyImpl.toFileName(o));
            } else if (i == 2) {
                l.add(o.get("NAME"));
            } else {
                l.add(XModelObjectUtil.expand(o.get("location"), o.getModel(), null));
                break;
            }
            o = o.getParent();
        }
        StringBuffer sb = new StringBuffer();
        int i = l.size() - 1;
        while (i >= 0) {
            if (sb.length() > 0) {
                sb.append('/');
            }
            sb.append((String)l.get(i));
            --i;
        }
        return sb.toString();
    }

    static String getExtension(String f) {
        return f.substring(f.lastIndexOf(46) + 1);
    }

    static XModelObject getEditorObject(XModel model, String ext) {
        XModelObject o = model.getByPath(EDITORS);
        String[] es = XModelObjectUtil.asStringArray(o.getAttributeValue("extensions"));
        int i = 0;
        while (i < es.length) {
            if (es[i].toLowerCase().startsWith(String.valueOf(ext.toLowerCase()) + ":")) {
                return o.getChildByPath(es[i].substring(ext.length() + 1));
            }
            ++i;
        }
        return null;
    }

    static String[] getEditorList(XModel model) {
        XModelObject o = model.getByPath(EDITORS);
        XModelObject[] os = o.getChildren();
        String[] res = new String[os.length];
        int i = 0;
        while (i < res.length) {
            res[i] = os[i].get("NAME");
            ++i;
        }
        return res;
    }

    static boolean validatePath(String actionname, XModelObject o) throws XModelException {
        int i;
        String[] paths = OpenWithHelper.getEnvironmentPaths();
        XModel model = o.getModel();
        String en = o.getModelEntity().getName();
        XEntityData[] dt = new XEntityData[]{XEntityDataImpl.create(new String[][]{{en, "yes"}, {"path", "yes"}})};
        String path = o.getAttributeValue("path").replace('\\', '/');
        XAttributeData ad = HUtil.find(dt, 0, "path");
        ad.setValue(path);
        ServiceDialog d = model.getService();
        do {
            String b;
            if ((b = ad.getValue()) == null || b.length() <= 0 || !OpenWithHelper.fileExists(b, paths)) continue;
            if (!b.equals(path)) {
                model.changeObjectAttribute(o, "path", b);
                model.saveOptions();
            }
            return true;
        } while ((i = d.showDialog(actionname, MessageFormat.format("Enter valid path for {0}", o.getPresentationString()), new String[]{ModelMessages.OK, ModelMessages.Cancel}, dt[0], 0)) == 0);
        return false;
    }

    static boolean fileExists(String filename, String[] paths) {
        filename = filename.replace('\\', '/');
        if (paths == null || filename.indexOf(47) >= 0) {
            return new File(filename).isFile();
        }
        int i = 0;
        while (i < paths.length) {
            String f = String.valueOf(paths[i]) + "/" + filename;
            if (new File(f).isFile()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static String[] getEnvironmentPaths() {
        String jlp = OSHelper.getProperty("PATH", "");
        StringTokenizer st = new StringTokenizer(jlp, File.pathSeparator);
        String[] ps = new String[st.countTokens()];
        int i = 0;
        while (i < ps.length) {
            ps[i] = st.nextToken();
            ++i;
        }
        return ps;
    }

    public static String getLogicalExtension(XModelObject object, XAction action) {
        String extension = action.getProperty("extension");
        return extension != null ? extension : OpenWithHelper.getExtension(OpenWithHelper.getFileName(object));
    }
}

