/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.java.generation;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.jboss.tools.common.java.generation.JavaBeanGenerator;
import org.jboss.tools.common.model.plugin.ModelPlugin;

public class JavaPropertyGenerator {
    IType owner;

    public void setOwner(IType owner) {
        this.owner = owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(String name, String javatype, String access, boolean field, boolean getter, boolean setter) throws CoreException {
        ICompilationUnit cu;
        access = "default".equals(access) ? "" : String.valueOf(access) + " ";
        String fa = getter && setter ? "private " : access;
        ICompilationUnit parentCU = this.owner.getCompilationUnit();
        String lineDelimiter = JavaPropertyGenerator.getLineDelimiterUsed(parentCU);
        ICompilationUnit createdWorkingCopy = parentCU.getWorkingCopy(null);
        IType createdType = createdWorkingCopy.getType(this.owner.getElementName());
        boolean isInterface = createdType.isInterface();
        ICompilationUnit iCompilationUnit = cu = createdType.getCompilationUnit();
        synchronized (iCompilationUnit) {
            cu.reconcile(0, true, null, null);
        }
        if (!(!field || isInterface || createdType.getField(name) != null && createdType.getField(name).exists())) {
            String fieldContents = "\t" + fa + javatype + " " + name + ";" + lineDelimiter;
            createdType.createField(fieldContents, null, true, null);
            ICompilationUnit iCompilationUnit2 = cu;
            synchronized (iCompilationUnit2) {
                cu.reconcile(0, true, null, null);
            }
        }
        if (getter) {
            JavaPropertyGenerator.createGetter(cu, createdType, access, javatype, name, lineDelimiter);
        }
        if (setter) {
            JavaPropertyGenerator.createSetter(cu, createdType, access, javatype, name, lineDelimiter);
        }
        cu.commitWorkingCopy(true, null);
    }

    public static void createGetter(ICompilationUnit cu, IType type, String access, String javatype, String name, String lineDelimiter) throws CoreException {
        String methodName = JavaPropertyGenerator.getAccessorName("get", name);
        if (JavaPropertyGenerator.findGetter(type, methodName) != null) {
            return;
        }
        String methodHeader = String.valueOf(access) + javatype + " " + methodName + "()";
        String stub = null;
        if (!type.isInterface()) {
            methodHeader = String.valueOf(methodHeader) + " {" + lineDelimiter;
            stub = String.valueOf(methodHeader) + "}" + lineDelimiter;
        } else {
            stub = methodHeader = String.valueOf(methodHeader) + ";" + lineDelimiter;
        }
        IMethod m = type.createMethod(stub, null, true, null);
        String methodComment = CodeGeneration.getGetterComment((ICompilationUnit)cu, (String)type.getElementName(), (String)m.getElementName(), (String)name, (String)javatype, (String)name, (String)lineDelimiter);
        String methodContent = type.isInterface() ? null : CodeGeneration.getGetterMethodBodyContent((ICompilationUnit)cu, (String)cu.getElementName(), (String)m.getElementName(), (String)name, (String)lineDelimiter);
        JavaPropertyGenerator.editMethod(cu, m, methodHeader, methodComment, methodContent, lineDelimiter);
    }

    static IMethod findGetter(IType type, String methodName) {
        if (type == null || methodName == null) {
            return null;
        }
        try {
            IMethod[] ms = type.getMethods();
            int i = 0;
            while (i < ms.length) {
                if (ms[i].getElementName().equals(methodName) && ms[i].getParameterNames().length == 0) {
                    return ms[i];
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        return null;
    }

    public static void createSetter(ICompilationUnit cu, IType type, String access, String javatype, String name, String lineDelimiter) throws CoreException {
        String methodName = JavaPropertyGenerator.getAccessorName("set", name);
        String methodHeader = String.valueOf(access) + "void " + methodName + "(" + javatype + " " + name + ")";
        String stub = null;
        if (!type.isInterface()) {
            methodHeader = String.valueOf(methodHeader) + " {" + lineDelimiter;
            stub = String.valueOf(methodHeader) + "}" + lineDelimiter;
        } else {
            stub = methodHeader = String.valueOf(methodHeader) + ";" + lineDelimiter;
        }
        IMethod m = type.createMethod(stub, null, true, null);
        String methodComment = CodeGeneration.getSetterComment((ICompilationUnit)cu, (String)type.getElementName(), (String)m.getElementName(), (String)name, (String)javatype, (String)name, (String)name, (String)lineDelimiter);
        String methodContent = type.isInterface() ? null : CodeGeneration.getSetterMethodBodyContent((ICompilationUnit)cu, (String)cu.getElementName(), (String)m.getElementName(), (String)("this." + name), (String)name, (String)lineDelimiter);
        JavaPropertyGenerator.editMethod(cu, m, methodHeader, methodComment, methodContent, lineDelimiter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void editMethod(ICompilationUnit cu, IMethod m, String methodHeader, String methodComment, String methodContent, String lineDelimiter) throws CoreException {
        String formattedContent;
        ICompilationUnit iCompilationUnit = cu;
        synchronized (iCompilationUnit) {
            cu.reconcile(0, true, null, null);
        }
        ISourceRange range = m.getSourceRange();
        IBuffer buf = cu.getBuffer();
        StringBuffer sb = new StringBuffer(lineDelimiter);
        if (PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.javadoc")) {
            sb.append(methodComment);
        }
        sb.append(methodHeader);
        if (methodContent != null) {
            sb.append(methodContent).append("}").append(lineDelimiter);
        }
        if ((formattedContent = JavaBeanGenerator.codeFormat2(4, sb.toString(), 1, lineDelimiter, cu.getJavaProject())) != null && formattedContent.startsWith("\t")) {
            formattedContent = formattedContent.substring(1);
        }
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
    }

    static String getAccessorName(String prefix, String name) {
        String namePart = String.valueOf(name.substring(0, 1).toUpperCase()) + name.substring(1);
        return String.valueOf(prefix) + namePart;
    }

    public static String getLineDelimiterUsed(ICompilationUnit cu) {
        if (cu == null || !cu.exists()) {
            return System.getProperty("line.separator", "\n");
        }
        IBuffer buf = null;
        try {
            buf = cu.getBuffer();
        }
        catch (JavaModelException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (buf == null) {
            return System.getProperty("line.separator", "\n");
        }
        int length = buf.getLength();
        int i = 0;
        while (i < length) {
            char ch = buf.getChar(i);
            if (ch == '\r') {
                if (i + 1 < length && buf.getChar(i + 1) == '\n') {
                    return "\r\n";
                }
                return "\r";
            }
            if (ch == '\n') {
                return "\n";
            }
            ++i;
        }
        return System.getProperty("line.separator", "\n");
    }
}

