/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.page;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XJob;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.model.StrutsProcessImpl;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.page.LinkRecognizer;
import org.jboss.tools.struts.model.helpers.page.PageLinks;
import org.jboss.tools.struts.model.helpers.page.link.Links;
import org.jboss.tools.struts.model.helpers.page.link.LinksListener;

public class PageUpdateManager
implements XModelTreeListener,
Runnable,
StrutsConstants {
    private static long id = 0L;
    private XModel model;
    private Map<String, PageLinks> pages = new HashMap<String, PageLinks>();
    private int lock = 0;
    protected boolean stopped = false;
    Links links;
    LinksListener linksListener;
    PageUpdateRunnable runnable = new PageUpdateRunnable();

    public static PageUpdateManager getInstance(XModel model) {
        PageUpdateManager instance = (PageUpdateManager)model.getManager("PageUpdateManager");
        if (instance == null) {
            instance = new PageUpdateManager();
            instance.model = model;
            try {
                instance.init();
            }
            catch (Exception e) {
                model.addModelTreeListener((XModelTreeListener)instance);
                StrutsModelPlugin.getPluginLog().logError("PageUpdateManager failed for " + model.getProperties().get("project"), (Throwable)e);
                return instance;
            }
            model.addManager("PageUpdateManager", (Object)instance);
            model.addModelTreeListener((XModelTreeListener)instance);
        }
        return instance;
    }

    private void init() {
        this.links = LinkRecognizer.getInstance().getLinks();
        this.linksListener = new LinksListenerImpl();
        this.links.addLinksListener(this.linksListener);
    }

    public void updatePage(StrutsProcessHelper h, XModelObject page) {
        if ("tile".equals(page.getAttributeValue("subtype"))) {
            h.updateTile(page);
            return;
        }
        PageLinks pl = this.getPageLinks(page);
        if (pl == null) {
            return;
        }
        pl.h = h;
        pl.update();
    }

    PageLinks getPageLinks(XModelObject page) {
        PageLinks pl;
        if (!"page".equals(page.getAttributeValue("type"))) {
            return null;
        }
        if ("tile".equals(page.getAttributeValue("subtype"))) {
            return null;
        }
        String pid = page.get("_page_id");
        if (pid == null) {
            pid = "" + ++id;
            page.set("_page_id", pid);
        }
        if ((pl = this.pages.get(pid)) == null) {
            pl = new PageLinks();
            pl.setPage(page);
            this.pages.put(pid, pl);
        }
        return pl;
    }

    public void updateAll() {
        if (this.isLocked()) {
            return;
        }
        this.lock();
        try {
            String[] ks = this.pages.keySet().toArray(new String[0]);
            int i = 0;
            while (i < ks.length) {
                PageLinks pl = this.pages.get(ks[i]);
                if (pl != null) {
                    if (!pl.page.isActive()) {
                        this.pages.remove(ks[i]);
                    } else {
                        pl.update();
                    }
                }
                ++i;
            }
        }
        finally {
            this.unlock();
        }
    }

    public boolean isLocked() {
        return this.lock > 0;
    }

    public void lock() {
        ++this.lock;
    }

    public void unlock() {
        --this.lock;
    }

    public void structureChanged(XModelTreeEvent event) {
        XModel model = event.getModelObject().getModel();
        if (event.kind() == 3 && event.getModelObject() == model.getRoot()) {
            model.removeModelTreeListener((XModelTreeListener)this);
            PageUpdateManager instance = (PageUpdateManager)model.getManager("PageUpdateManager");
            if (instance != null) {
                instance.stopped = true;
                model.removeManager("PageUpdateManager");
            }
            if (this.linksListener != null) {
                this.links.addLinksListener(this.linksListener);
                this.linksListener = null;
                this.links = null;
            }
            return;
        }
        if (event.kind() == 1) {
            this.onChildAdded(event);
        }
        if (this.isLocked()) {
            return;
        }
        XJob.addRunnable((XJob.XRunnable)this.runnable);
    }

    private void onChildAdded(XModelTreeEvent event) {
        XModelObject c = (XModelObject)event.getInfo();
        if (!c.getModelEntity().getName().equals("StrutsProcessItem")) {
            return;
        }
        StrutsProcessImpl pi = (StrutsProcessImpl)event.getModelObject();
        PageLinks pl = this.getPageLinks(c);
        if (pl == null || pi.getHelper() == null) {
            return;
        }
        pl.h = pi.getHelper();
    }

    public void nodeChanged(XModelTreeEvent event) {
        if (this.isLocked()) {
            return;
        }
        XJob.addRunnable((XJob.XRunnable)this.runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!this.stopped) {
            PageUpdateManager pageUpdateManager = this;
            synchronized (pageUpdateManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    StrutsModelPlugin.getPluginLog().logInfo(ie.getMessage(), (Throwable)ie);
                }
                catch (Exception e) {
                    StrutsModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException ie) {
                StrutsModelPlugin.getPluginLog().logInfo(ie.getMessage(), (Throwable)ie);
            }
            catch (Exception e) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)e);
            }
            if (this.stopped) break;
            if (this.isLocked()) continue;
            try {
                this.updateAll();
            }
            catch (Exception t) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)t);
            }
        }
    }

    class LinksListenerImpl
    implements LinksListener {
        LinksListenerImpl() {
        }

        public void linksChanged() {
            PageLinks[] ps = PageUpdateManager.this.pages.values().toArray(new PageLinks[0]);
            int i = 0;
            while (i < ps.length) {
                ps[i].jspTimeStamp = -1L;
                ++i;
            }
            PageUpdateManager.this.nodeChanged(null);
        }
    }

    class PageUpdateRunnable
    implements XJob.XRunnable {
        PageUpdateRunnable() {
        }

        public String getId() {
            return "Page Update - " + XModelConstants.getWorkspace((XModel)PageUpdateManager.this.model);
        }

        public void run() {
            if (!PageUpdateManager.this.isLocked()) {
                try {
                    PageUpdateManager.this.updateAll();
                }
                catch (Exception t) {
                    StrutsModelPlugin.getPluginLog().logError((Throwable)t);
                }
            }
        }
    }
}

