/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers.page;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.model.helpers.page.JSPLinksParser;
import org.jboss.tools.struts.model.helpers.page.LinkRecognizer;

class PageLinks
implements StrutsConstants {
    StrutsProcessHelper h;
    XModelObject page;
    XModelObject jsp;
    boolean confirmed = false;
    long jspTimeStamp;
    long pageTimeStamp;
    JSPLinksParser parser = new JSPLinksParser(LinkRecognizer.getInstance().getLinks());

    PageLinks() {
    }

    public void setPage(XModelObject page) {
        this.page = page;
        this.parser.setUrlPattern(StrutsProcessStructureHelper.instance.getUrlPattern(page));
    }

    public void update() {
        if (this.page.getParent() == null) {
            return;
        }
        boolean modified = this.pageTimeStamp != this.page.getTimeStamp();
        this.pageTimeStamp = this.page.getTimeStamp();
        String path = StrutsProcessStructureHelper.instance.getModulePagePath(this.page);
        if (path == null || StrutsProcessHelper.isHttp(path)) {
            this.jsp = null;
            this.setConfirmed(false);
            this.jspTimeStamp = -1L;
            if (modified) {
                this.update0();
            }
            return;
        }
        XModelObject jsp1 = StrutsProcessStructureHelper.instance.findReferencedJSPInCurrentModule(this.page);
        if (this.jsp == null || !this.jsp.isActive() || this.jsp != jsp1) {
            this.jsp = jsp1;
            this.setConfirmed(this.jsp != null);
            this.jspTimeStamp = -1L;
            if (this.jsp == null) {
                if (modified) {
                    this.update0();
                }
                return;
            }
        }
        if (this.jsp.getTimeStamp() != this.jspTimeStamp) {
            JSPLinksParser p1 = new JSPLinksParser(LinkRecognizer.getInstance().getLinks());
            p1.setUrlPattern(StrutsProcessStructureHelper.instance.getUrlPattern(this.page));
            p1.setSource(this.jsp.getAttributeValue("body"));
            p1.parse();
            modified = p1.areLinksModified(this.parser) || this.jspTimeStamp == -1L;
            this.parser = p1;
            this.jspTimeStamp = this.jsp.getTimeStamp();
        }
        this.update0();
    }

    private void update0() {
        this.h.updatePage(this.page, this.parser);
    }

    private void setConfirmed(boolean b) {
        this.confirmed = b;
        if (this.confirmed == "true".equals(this.page.get("confirmed"))) {
            return;
        }
        this.page.setAttributeValue("confirmed", "" + this.confirmed);
        if (!this.confirmed) {
            XModelObject[] links = this.page.getChildren();
            int i = 0;
            while (i < links.length) {
                links[i].setAttributeValue("subtype", "");
                ++i;
            }
        }
    }
}

