/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.jst.web.model.helpers.WebProcessUpdateHelper;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.model.ReferenceObjectImpl;
import org.jboss.tools.struts.model.StrutsProcessImpl;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.StrutsUpdateManager;

public class StrutsUpdateHelper
implements StrutsConstants,
WebProcessUpdateHelper {
    private XModelObject config;
    private StrutsProcessImpl process;
    private StrutsProcessHelper helper;
    private Map<String, Updater> updaters = new HashMap<String, Updater>();

    public StrutsUpdateHelper(StrutsProcessImpl process) {
        this.process = process;
        this.helper = process.getHelper();
        this.config = process.getParent();
        this.updaters.put("global-forwards", new ForwardUpdater());
        this.updaters.put("global-exceptions", new ExceptionUpdater());
        this.updaters.put("action-mappings", new ActionUpdater());
        StrutsUpdateManager.getInstance(process.getModel()).register(this.config.getPath(), this);
    }

    public void unregister() {
        StrutsUpdateManager.getInstance(this.process.getModel()).unregister(this.config.getPath(), this);
    }

    public boolean isActive() {
        return this.process.isActive();
    }

    public void nodeChanged(XModelTreeEvent event, String localPath) {
        int index = localPath == null ? -1 : localPath.indexOf(47);
        String subRootName = index == -1 ? localPath : localPath.substring(0, index);
        Updater updater = this.updaters.get(subRootName);
        if (updater != null) {
            updater.nodeChanged(localPath);
        }
    }

    public void structureChanged(XModelTreeEvent event, String localPath) {
        int index = localPath == null ? -1 : localPath.indexOf(47);
        String subRootName = index == -1 ? localPath : localPath.substring(0, index);
        Updater updater = this.updaters.get(subRootName);
        if (updater != null) {
            switch (event.kind()) {
                case 1: {
                    XModelObject child = (XModelObject)event.getInfo();
                    updater.childAdded(child);
                    break;
                }
                case 2: {
                    updater.childRemoved(localPath);
                    break;
                }
                case 3: {
                    updater.structureChanged(localPath);
                }
            }
        }
    }

    private void resolveAndReduce() {
        this.helper.resolve();
        this.helper.removeUnconfirmed();
    }

    class ActionUpdater
    implements Updater {
        ActionUpdater() {
        }

        public void childAdded(XModelObject child) {
            while (!child.getModelEntity().getName().startsWith("StrutsAction")) {
                child = child.getParent();
            }
            StrutsUpdateHelper.this.helper.reloadAction((XModelObject)StrutsUpdateHelper.this.process, child, StrutsUpdateHelper.this.helper.getObject("action-mappings/" + child.getPathPart()));
            StrutsUpdateHelper.this.helper.resolve();
        }

        public void childRemoved(String localPath) {
            String actionPath = this.getActionPath(localPath);
            XModelObject action = StrutsUpdateHelper.this.helper.getObject(actionPath);
            if (action != null) {
                if (localPath.equals(actionPath)) {
                    StrutsUpdateHelper.this.helper.removeAction(action);
                } else {
                    StrutsUpdateHelper.this.helper.reloadAction((XModelObject)StrutsUpdateHelper.this.process, StrutsUpdateHelper.this.config.getChildByPath(actionPath), action);
                }
                StrutsUpdateHelper.this.resolveAndReduce();
            }
        }

        public void nodeChanged(String localPath) {
            localPath = this.getActionPath(localPath);
            XModelObject action = StrutsUpdateHelper.this.helper.getObject(localPath);
            if (action != null) {
                StrutsUpdateHelper.this.helper.reloadAction((XModelObject)StrutsUpdateHelper.this.process, ((ReferenceObjectImpl)action).getReference(), action);
                StrutsUpdateHelper.this.resolveAndReduce();
            }
        }

        public void structureChanged(String localPath) {
            if (localPath.indexOf(47) == -1) {
                StrutsUpdateHelper.this.helper.updateProcess();
                return;
            }
            localPath = this.getActionPath(localPath);
            XModelObject action = StrutsUpdateHelper.this.helper.getObject(localPath);
            if (action != null) {
                StrutsUpdateHelper.this.helper.reloadAction((XModelObject)StrutsUpdateHelper.this.process, ((ReferenceObjectImpl)action).getReference(), action);
                StrutsUpdateHelper.this.resolveAndReduce();
            }
        }

        private String getActionPath(String localPath) {
            int ind1 = localPath.indexOf(47);
            if (ind1 == -1) {
                return null;
            }
            int ind2 = localPath.indexOf(47, ind1 + 1);
            return ind2 == -1 ? localPath : localPath.substring(0, ind2);
        }
    }

    class ExceptionUpdater
    implements Updater {
        ExceptionUpdater() {
        }

        public void childAdded(XModelObject child) {
            if (!child.getModelEntity().getName().startsWith("StrutsException")) {
                return;
            }
            StrutsUpdateHelper.this.helper.reloadException((XModelObject)StrutsUpdateHelper.this.process, child, null);
            StrutsUpdateHelper.this.helper.resolve();
        }

        public void childRemoved(String localPath) {
            XModelObject exception = StrutsUpdateHelper.this.helper.getObject(localPath);
            if (exception != null) {
                StrutsUpdateHelper.this.helper.reloadException((XModelObject)StrutsUpdateHelper.this.process, null, exception);
                StrutsUpdateHelper.this.resolveAndReduce();
            }
        }

        public void nodeChanged(String localPath) {
            XModelObject exception = StrutsUpdateHelper.this.helper.getObject(localPath);
            if (exception != null) {
                StrutsUpdateHelper.this.helper.reloadException((XModelObject)StrutsUpdateHelper.this.process, ((ReferenceObjectImpl)exception).getReference(), exception);
                StrutsUpdateHelper.this.resolveAndReduce();
            }
        }

        public void structureChanged(String localPath) {
            if (localPath.indexOf(47) == -1) {
                StrutsUpdateHelper.this.helper.updateProcess();
            }
        }
    }

    class ForwardUpdater
    implements Updater {
        ForwardUpdater() {
        }

        public void childAdded(XModelObject child) {
            if (!child.getModelEntity().getName().startsWith("StrutsForward")) {
                return;
            }
            StrutsUpdateHelper.this.helper.reloadForward((XModelObject)StrutsUpdateHelper.this.process, child, null);
            StrutsUpdateHelper.this.helper.resolve();
        }

        public void childRemoved(String localPath) {
            XModelObject forward = StrutsUpdateHelper.this.helper.getObject(localPath);
            if (forward != null) {
                StrutsUpdateHelper.this.helper.reloadForward((XModelObject)StrutsUpdateHelper.this.process, null, forward);
                StrutsUpdateHelper.this.resolveAndReduce();
            }
        }

        public void nodeChanged(String localPath) {
            XModelObject forward = StrutsUpdateHelper.this.helper.getObject(localPath);
            if (forward != null) {
                StrutsUpdateHelper.this.helper.reloadForward((XModelObject)StrutsUpdateHelper.this.process, ((ReferenceObjectImpl)forward).getReference(), forward);
                StrutsUpdateHelper.this.resolveAndReduce();
            }
        }

        public void structureChanged(String localPath) {
            if (localPath.indexOf(47) == -1) {
                StrutsUpdateHelper.this.helper.updateProcess();
            }
        }
    }

    static interface Updater {
        public void childAdded(XModelObject var1);

        public void childRemoved(String var1);

        public void structureChanged(String var1);

        public void nodeChanged(String var1);
    }
}

