/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers.page.create;

import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jst.jsp.ui.internal.JSPUIPlugin;
import org.eclipse.jst.jsp.ui.internal.templates.TemplateContextTypeIdsJSP;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.DefaultWizardDataValidator;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.StrutsPreference;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.model.handlers.page.create.CreatePageContext;
import org.jboss.tools.struts.model.helpers.StrutsProcessHelper;
import org.jboss.tools.struts.model.helpers.page.PageUpdateManager;

public class CreatePageSupport
extends SpecialWizardSupport {
    static String LAST_CREATE_FILE_PREFERENCE = "org.jboss.tools.struts.lastCreateFileValue";
    static String ATTR_FILE_SYSTEM = "file system";
    protected CreatePageContext context = new CreatePageContext();
    String lastCreateFileValue = "true";
    Map<String, Template> templates = null;
    protected DefaultWizardDataValidator validator = new Validator();

    public CreatePageSupport() {
        this.context.setSupport(this);
    }

    public String[] getActionNames(int stepId) {
        return new String[]{FINISH, CANCEL};
    }

    protected void reset() {
        this.context.reset();
        if (this.context.getSelectedFileSystem() != null) {
            this.setStepId(1);
        } else {
            this.setStepId(0);
        }
        if (this.getStepId() > 0) {
            this.setAttributeContext(this.getStepId(), "name", (Object)this);
        }
        if (this.context.isPreselected()) {
            try {
                this.onSelection();
            }
            catch (XModelException e) {
                StrutsModelPlugin.getPluginLog().logError("Exception caught in CreatePageSupport:reset " + e.getMessage(), (Throwable)e);
            }
        } else {
            String last;
            this.loadTemplates();
            String[] s = this.templates.keySet().toArray(new String[0]);
            this.setValueList(this.getStepId(), "template", s);
            if (s.length > 0) {
                this.setAttributeValue(this.getStepId(), "template", this.getDefaultTemplate(s));
            }
            if ((last = StrutsModelPlugin.getDefault().getPreferenceStore().getString(LAST_CREATE_FILE_PREFERENCE)) == null || last.length() == 0) {
                last = "true";
            } else if (!"true".equals(last)) {
                last = "false";
            }
            this.setAttributeValue(this.getStepId(), "create file", last);
        }
    }

    TemplateStore getTemplateStore() {
        return JSPUIPlugin.getInstance().getTemplateStore();
    }

    String getTemplateString(String templateName) {
        if (templateName == null) {
            return null;
        }
        String templateString = null;
        Template template = this.templates.get(templateName);
        if (template != null) {
            TemplateContextType contextType = JSPUIPlugin.getInstance().getTemplateContextRegistry().getContextType(TemplateContextTypeIdsJSP.NEW);
            Document document = new Document();
            DocumentTemplateContext context = new DocumentTemplateContext(contextType, (IDocument)document, 0, 0);
            try {
                TemplateBuffer buffer = context.evaluate(template);
                templateString = buffer.getString();
            }
            catch (Exception e) {
                StrutsModelPlugin.getDefault().logWarning("Could not create template for new html", e);
            }
        }
        return templateString;
    }

    void loadTemplates() {
        Template[] ts;
        this.templates = new TreeMap<String, Template>();
        Template[] templateArray = ts = this.getTemplateStore().getTemplates(TemplateContextTypeIdsJSP.NEW);
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            Template t = templateArray[n2];
            this.templates.put(t.getName(), t);
            ++n2;
        }
    }

    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            this.finish();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.setStepId(-1);
            this.setFinished(true);
        } else if (name.startsWith("...")) {
            this.context.update();
            this.callSelector();
        }
    }

    private void callSelector() throws XModelException {
        XModelObject so;
        String b = this.getValidatedName(false);
        if (b != null && b.endsWith("/")) {
            b = b.substring(0, b.length() - 1);
        }
        XModelObject xModelObject = so = b == null || b.length() == 0 ? null : this.getTarget().getModel().getByPath(b);
        if (so != null) {
            this.getProperties().put("selectedObject", so);
        } else {
            this.getProperties().remove("selectedObject");
        }
        XModelObject fs = this.context.getSelectedFileSystem();
        if (fs != null) {
            this.getProperties().put("selectedFileSystem", fs);
        } else {
            this.getProperties().remove("selectedFileSystem");
        }
        this.getProperties().remove("SelectPage.cancelled");
        XActionInvoker.invoke((String)"StrutsCreatePageWizard_Selector", (String)"SelectPage", (XModelObject)this.getTarget(), (Properties)this.getProperties());
        if (this.getProperties().getProperty("SelectPage.cancelled") != null) {
            return;
        }
        this.onSelection();
    }

    private void onSelection() throws XModelException {
        XModelObject fs;
        XModelObject so = (XModelObject)this.getProperties().get("selectedObject");
        if (so != null) {
            String p = XModelObjectLoaderUtil.getResourcePath((XModelObject)so);
            if (so.getFileType() > 1) {
                p = String.valueOf(p) + "/";
            }
            this.setAttributeValue(this.getStepId(), "name", p);
        }
        if ((fs = (XModelObject)this.getProperties().get("selectedFileSystem")) != null) {
            this.context.setSelectedFileSystem(fs);
        }
        if (so != null && this.getAttributeValue(this.getStepId(), "name").length() > 0 && so.getFileType() == 1) {
            Properties pp = new Properties();
            pp.setProperty("name", this.getAttributeValue(this.getStepId(), "name"));
            this.getValidator(this.getStepId()).validate(pp);
            if (this.validator.getErrorMessage() == null) {
                this.action(FINISH);
            }
        }
    }

    public boolean isActionEnabled(String name) {
        int id;
        String v;
        return !FINISH.equals(name) || (v = this.getAttributeValue(id = this.getStepId(), "name")) != null && v.length() != 0 && this.context.isPage(v);
    }

    public String[][] getInfo(int stepId) {
        if (stepId != 1) {
            return null;
        }
        XModelObject fs = this.context.getSelectedFileSystem();
        String s = fs == null ? "" : this.context.getRootInfo(fs);
        return new String[][]{{"Current Module Root", s}};
    }

    private String getValidatedName(boolean save) {
        String b = this.getAttributeValue(this.getStepId(), "name");
        if (b != null && b.length() > 0) {
            String b1;
            if (!b.startsWith("/")) {
                b = "/" + b;
                if (save) {
                    this.setAttributeValue(this.getStepId(), "name", b);
                }
            }
            if (!b.endsWith("/") && b.indexOf(46) < 0) {
                b = String.valueOf(b) + CreatePageSupport.getExtension();
                if (save) {
                    this.setAttributeValue(this.getStepId(), "name", b);
                }
            }
            if (!(b1 = this.context.revalidatePath(b)).equals(b)) {
                b = b1;
                this.setAttributeValue(this.getStepId(), "name", b);
            }
        }
        return b;
    }

    private void finish() throws XModelException {
        this.getValidatedName(true);
        this.extractStepData(this.getStepId());
        this.context.update();
        XUndoManager undo = this.getTarget().getModel().getUndoManager();
        XTransactionUndo u = new XTransactionUndo("create page in struts process " + DefaultCreateHandler.title((XModelObject)this.getTarget().getParent(), (boolean)false), 1);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.transaction();
            }
            catch (Exception e) {
                undo.rollbackTransactionInProgress();
                throw new XModelException((Throwable)e);
            }
        }
        finally {
            u.commit();
        }
    }

    private String getFullPath(String path) {
        String root = this.context.getRoot();
        String thisRoot = this.context.getThisRoot();
        String fullpath = path;
        if (root != null) {
            if (root.equals(thisRoot)) {
                if (path.startsWith(String.valueOf(root) + "/")) {
                    fullpath = path = path.substring(root.length());
                }
            } else if (!path.startsWith(String.valueOf(root) + "/")) {
                fullpath = String.valueOf(root) + path;
            }
        }
        return fullpath;
    }

    private String getExistsMessage(String fullpath, String path) {
        if (this.context.pageExists(fullpath.toLowerCase())) {
            return String.valueOf(DefaultCreateHandler.title((XModelObject)this.getTarget().getParent(), (boolean)true)) + " contains page " + path;
        }
        return null;
    }

    private void transaction() throws Exception {
        int id = this.getStepId();
        String path = this.getAttributeValue(id, "name");
        String fullpath = this.getFullPath(path);
        String msg = this.getExistsMessage(fullpath, path);
        if (msg != null) {
            throw new Exception(msg);
        }
        this.createFile(path);
        StrutsProcessHelper ph = StrutsProcessHelper.getHelper(this.getTarget());
        XModelObject item = ph.getPage(fullpath);
        if (item != null) {
            return;
        }
        CreatePageSupport.createPage(this.getTarget(), fullpath, this.getProperties());
    }

    public static XModelObject createPage(XModelObject process, String path, Properties p) throws XModelException {
        String y;
        XModelObject item = StrutsProcessHelper.createPage(process, path);
        String x = p == null ? null : p.getProperty("process.mouse.x");
        String string = y = p == null ? null : p.getProperty("process.mouse.y");
        if (x != null && y != null) {
            item.setAttributeValue("shape", x + "," + y + ",0,0");
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)process, (XModelObject)item, (int)-1);
        StrutsProcessHelper ph = StrutsProcessHelper.getHelper(process);
        ph.updateTiles();
        PageUpdateManager.getInstance(item.getModel()).updatePage(ph, item);
        return item;
    }

    private void createFile(String path) throws Exception {
        if (!this.canCreateFile()) {
            return;
        }
        String lastCreateFileValue = this.getAttributeValue(this.getStepId(), "create file");
        StrutsModelPlugin.getDefault().getPreferenceStore().setDefault(LAST_CREATE_FILE_PREFERENCE, lastCreateFileValue);
        if (!"true".equals(lastCreateFileValue)) {
            return;
        }
        String template = this.getAttributeValue(this.getStepId(), "template").trim();
        String body = template == null ? "" : this.getTemplateString(template);
        XModelObject fs = this.context.getSelectedFileSystem();
        if (fs == null) {
            return;
        }
        CreatePageSupport.createFile(fs, path, body);
    }

    public static void createFile(XModelObject fs, String path, String body) throws XModelException {
        String s;
        StringTokenizer st = new StringTokenizer(path, "/");
        int c = st.countTokens();
        int i = 0;
        while (i < c - 1) {
            s = st.nextToken();
            XModelObject o = fs.getChildByPath(s);
            if (o == null) {
                o = fs.getModel().createModelObject("FileFolder", null);
                o.setAttributeValue("name", s);
                DefaultCreateHandler.addCreatedObject((XModelObject)fs, (XModelObject)o, (int)-1);
                ((FolderImpl)o).save();
            }
            fs = o;
            ++i;
        }
        s = st.nextToken().trim();
        if (s.length() == 0) {
            return;
        }
        int dot = s.lastIndexOf(46);
        if (dot < 0) {
            s = String.valueOf(s) + CreatePageSupport.getExtension();
            dot = s.indexOf(46);
        }
        String n = s.substring(0, dot);
        String e = s.substring(dot + 1);
        String entity = "jsp".equals(e) ? "FileJSP" : ("htm".equals(e) ? "FileHTML" : ("html".equals(e) ? "FileHTML" : (CreatePageSupport.getExtension().equals(e) ? "FileTXT" : "FileAny")));
        XModelObject f = fs.getModel().createModelObject(entity, null);
        f.setAttributeValue("name", n);
        f.setAttributeValue("extension", e);
        if (body != null) {
            f.setAttributeValue("body", body);
        }
        if (fs.getChildByPath(f.getPathPart()) != null) {
            return;
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)fs, (XModelObject)f, (int)-1);
        ((FolderImpl)fs).saveChild(f);
    }

    static XModelObject getPreferenceObject() {
        return PreferenceModelUtilities.getPreferenceModel().getByPath(StrutsPreference.ADD_PAGE_PATH);
    }

    public String getDefaultTemplate(String[] list) {
        String v;
        if (list.length == 0) {
            return "";
        }
        XModelObject addPage = CreatePageSupport.getPreferenceObject();
        String string = v = addPage == null ? "" : addPage.getAttributeValue("Page Template");
        if (v != null) {
            int i = 0;
            while (i < list.length) {
                if (v.equals(list[i])) {
                    return list[i];
                }
                ++i;
            }
        }
        return list[0];
    }

    public static String getExtension() {
        String v;
        XModelObject addPage = CreatePageSupport.getPreferenceObject();
        String string = v = addPage == null ? "" : addPage.getAttributeValue("Extension");
        if (v == null || v.length() == 0) {
            return ".jsp";
        }
        if (!v.startsWith(".")) {
            v = "." + v;
        }
        return v;
    }

    public WizardDataValidator getValidator(int step) {
        this.validator.setSupport((SpecialWizardSupport)this, step);
        return this.validator;
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        boolean g;
        this.setAttributeValue(this.getStepId(), "name", values.getProperty("name"));
        boolean c = this.canCreateFile();
        if (name.equals("create file")) {
            return c;
        }
        boolean bl = g = c && "true".equals(values.getProperty("create file"));
        if (name.equals("template")) {
            return g;
        }
        return true;
    }

    public boolean canCreateFile() {
        String path = this.getValidatedName(false);
        if (path == null || path.length() == 0 || path.startsWith("http:")) {
            return false;
        }
        return this.isCorrectPath(path) && !this.fileExists(path);
    }

    boolean isCorrectPath(String path) {
        return path != null && !path.equals("/") && path.indexOf("//") < 0;
    }

    boolean fileExists(String path) {
        if (this.context.getSelectedFileSystem() != null && path != null && path.startsWith("/")) {
            return this.context.getSelectedFileSystem().getChildByPath(path.substring(1)) != null;
        }
        return this.getTarget().getModel().getByPath(path) != null;
    }

    class Validator
    extends DefaultWizardDataValidator {
        Validator() {
        }

        public void validate(Properties data) {
            super.validate(data);
            if (this.message != null) {
                return;
            }
            String path = data.getProperty("name");
            if (path != null && path.length() > 0) {
                String b1;
                if (!path.startsWith("/")) {
                    path = "/" + path;
                }
                if (!path.endsWith("/") && path.indexOf(46) < 0) {
                    path = String.valueOf(path) + CreatePageSupport.getExtension();
                }
                if (!(b1 = CreatePageSupport.this.context.revalidatePath(path)).equals(path)) {
                    path = b1;
                }
            }
            this.message = CreatePageSupport.this.getExistsMessage(CreatePageSupport.this.getFullPath(path), path);
            if (this.message != null) {
                return;
            }
            String template = data.getProperty("template");
            if (template != null && CreatePageSupport.this.isFieldEditorEnabled(0, "template", data)) {
                if (template.trim().length() == 0) {
                    this.message = StrutsUIMessages.TEMPLATE_ISNOT_SPECIFIED;
                    return;
                }
                String t = CreatePageSupport.this.getTemplateString(template.trim());
                if (t == null) {
                    this.message = StrutsUIMessages.TEMPLATE_DOESNT_EXIST;
                }
            }
            if (this.message != null) {
                return;
            }
            if (!CreatePageSupport.this.context.isPage(path)) {
                String d;
                this.message = path.endsWith("/") ? StrutsUIMessages.PATH_CANNOT_END_WITH : ((d = CreatePageSupport.getExtension().substring(1)).equals(".jsp") ? StrutsUIMessages.PATH_EXTENSION_MUST_BE_JSP_HTM_HTML : NLS.bind((String)StrutsUIMessages.PATH_EXTENSION_MUST_BE, (Object)d));
            }
        }
    }
}

