/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers.page.create;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.model.handlers.page.create.CreatePageSupport;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

public class CreatePageContext
implements StrutsConstants {
    protected CreatePageSupport support;
    protected XModelObject process = null;
    protected Map<String, String> roots = new HashMap<String, String>();
    protected XModelObject selectedFileSystem = null;
    private Set<String> pages = new HashSet<String>();
    protected XModelObject preselected = null;
    protected String thisModuleRoot = null;

    public void setSupport(CreatePageSupport support) {
        this.support = support;
    }

    public void setProcess(XModelObject o) {
        while (o != null && o.getFileType() != 1) {
            o = o.getParent();
        }
        this.process = o.getChildByPath("process");
    }

    public void reset() {
        if (this.support != null) {
            this.process = this.support.getTarget();
        }
        this.resetRoots();
        this.resetPages();
        if (this.support != null) {
            this.support.getProperties().put("context", this);
        }
        this.checkPreselected();
    }

    private void checkPreselected() {
        this.preselected = (XModelObject)this.support.getProperties().get("preselectedObject");
        if (this.preselected == null) {
            return;
        }
        this.support.getProperties().put("selectedObject", this.preselected);
        XModelObject o = this.preselected;
        while (o != null && o.getFileType() != 3) {
            o = o.getParent();
        }
        this.selectedFileSystem = o;
        if (this.selectedFileSystem != null && this.roots.get(this.selectedFileSystem.getPathPart()) == null && "WEB-INF".equals(this.selectedFileSystem.getPathPart())) {
            String path = "FileSystems/WEB-ROOT" + this.preselected.getPath().substring("FileSystems".length());
            XModelObject p2 = o.getModel().getByPath(path);
            if (p2 != null) {
                this.preselected = p2;
                this.support.getProperties().put("selectedObject", p2);
                this.selectedFileSystem = o.getModel().getByPath("FileSystems/WEB-ROOT");
            }
        }
        if (this.selectedFileSystem != null) {
            this.support.getProperties().put("selectedFileSystem", this.selectedFileSystem);
        }
    }

    public boolean isConfig10() {
        return this.process.getParent().getModelEntity().getName().endsWith("10");
    }

    public String getRoot() {
        return this.selectedFileSystem == null ? null : this.roots.get(this.selectedFileSystem.getPathPart());
    }

    public String getThisRoot() {
        return this.thisModuleRoot == null ? "" : this.thisModuleRoot;
    }

    public boolean isPreselected() {
        return this.preselected != null;
    }

    public String getRootInfo(XModelObject fs) {
        String module = this.roots.get(fs.getPathPart());
        return module != null ? String.valueOf(module) + " (" + fs.getPathPart() + ")" : fs.getPathPart();
    }

    public void setSelectedFileSystem(XModelObject o) {
        this.selectedFileSystem = o;
    }

    public XModelObject getSelectedFileSystem() {
        return this.selectedFileSystem;
    }

    public String getSelectedRoot() {
        return this.selectedFileSystem == null ? null : this.selectedFileSystem.getPathPart();
    }

    public void resetRoots() {
        this.thisModuleRoot = WebModulesHelper.getInstance(this.process.getModel()).getModuleForConfig(this.process.getParent());
        if (this.thisModuleRoot == null) {
            this.thisModuleRoot = "";
        }
        this.selectedFileSystem = null;
        Map<String, XModelObject> map = WebModulesHelper.getInstance(this.process.getModel()).getWebFileSystems();
        for (String module : map.keySet()) {
            boolean isThisModule;
            XModelObject fs = map.get(module);
            boolean isWebroot = module.length() == 0;
            boolean bl = isThisModule = this.thisModuleRoot.length() > 0 && this.thisModuleRoot.equals(module);
            if (isThisModule) {
                this.roots.put(fs.getPathPart(), module);
                this.selectedFileSystem = fs;
                continue;
            }
            if (isWebroot) {
                if (this.selectedFileSystem != null) continue;
                this.selectedFileSystem = fs;
                continue;
            }
            if (module == null || module.length() <= 0) continue;
            this.roots.put(fs.getPathPart(), module);
        }
    }

    public void update() {
    }

    private void resetPages() {
        this.pages.clear();
        XModelObject[] ps = this.process.getChildren();
        int i = 0;
        while (i < ps.length) {
            String path = ps[i].getAttributeValue("path");
            if (path != null) {
                this.pages.add(path.toLowerCase());
            }
            ++i;
        }
    }

    public boolean pageExists(String path) {
        return this.pages.contains(path);
    }

    public boolean isPage(String v) {
        if (v.startsWith("http:")) {
            return true;
        }
        return v.endsWith(".jsp") || v.endsWith(".htm") || v.endsWith(".html") || v.endsWith(CreatePageSupport.getExtension()) || v.endsWith(".tld") || !v.endsWith("/") && v.indexOf(46) < 0;
    }

    public String revalidatePath(String path) {
        if (this.getRoot() != null || !path.startsWith("/")) {
            return path;
        }
        return this.setRootByPath(path);
    }

    public String setRootByPath(String path) {
        for (String fsp : this.roots.keySet()) {
            String m = this.roots.get(fsp);
            if (!path.startsWith(String.valueOf(m) + "/")) continue;
            this.setSelectedFileSystem(this.process.getModel().getByPath("FileSystems/" + fsp));
            return path.substring(m.length());
        }
        return path;
    }
}

