/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileAuxiliary;
import org.jboss.tools.common.model.filesystems.impl.AbstractXMLFileImpl;
import org.jboss.tools.common.model.loaders.impl.SimpleWebFileLoader;
import org.jboss.tools.common.model.util.EntityXMLRegistration;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.AbstractWebDiagramLoader;
import org.jboss.tools.jst.web.model.WebProcessLoader;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.model.SCUtil;
import org.jboss.tools.struts.model.SPUtil;
import org.jboss.tools.struts.model.StrutsProcessImpl;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StrutsConfigLoader
extends AbstractWebDiagramLoader
implements WebProcessLoader,
StrutsConstants {
    public static String LAYOUT_FILE_EXTENSION = "strutsdia";
    private SPUtil sputil = new SPUtil();

    protected FileAuxiliary createFileAuxiliary() {
        return new FileAuxiliary(LAYOUT_FILE_EXTENSION, false);
    }

    protected XModelObjectLoaderUtil createUtil() {
        return new SCUtil();
    }

    int getVersion(String entity) {
        if (entity.endsWith("10")) {
            return 10;
        }
        if (entity.endsWith("11")) {
            return 11;
        }
        if (entity.endsWith("12")) {
            return 12;
        }
        return 11;
    }

    public void load(XModelObject object) {
        boolean hasErrors;
        String entity = object.getModelEntity().getName();
        int version = this.getVersion(entity);
        String body = XModelObjectLoaderUtil.getTempBody((XModelObject)object);
        int resolution = EntityXMLRegistration.getInstance().resolve(object.getModelEntity());
        String[] errors = XMLUtil.getXMLErrors((Reader)new StringReader(body), (resolution == EntityXMLRegistration.DTD ? 1 : 0) != 0, (resolution == EntityXMLRegistration.SCHEMA ? 1 : 0) != 0);
        boolean bl = hasErrors = errors != null && errors.length > 0;
        if (hasErrors) {
            object.setAttributeValue("isIncorrect", "yes");
            object.setAttributeValue("incorrectBody", body);
            object.set("actualBodyTimeStamp", "-1");
        } else {
            object.setAttributeValue("isIncorrect", "no");
            object.set("correctBody", body);
            object.set("actualBodyTimeStamp", "0");
            object.setAttributeValue("incorrectBody", "");
        }
        Document doc = XMLUtil.getDocument((Reader)new StringReader(body));
        if (doc == null) {
            return;
        }
        Element element = doc.getDocumentElement();
        this.util.load(element, object);
        this.setEncoding(object, body);
        NodeList nl = doc.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof DocumentType) {
                DocumentType dt = (DocumentType)n;
                object.setAttributeValue("systemId", dt.getSystemId());
            }
            ++i;
        }
        if (version != 10) {
            this.util.loadChildren(element, object.getChildren("StrutsMessageResourcesFolder11")[0]);
            this.util.loadChildren(element, object.getChildren("StrutsPluginFolder11")[0]);
        }
        String loadingError = this.util.getError();
        this.reloadProcess(object);
        object.set("actualBodyTimeStamp", "" + object.getTimeStamp());
        ((AbstractXMLFileImpl)object).setLoaderError(loadingError);
        if (!hasErrors && loadingError != null) {
            object.setAttributeValue("isIncorrect", "yes");
            object.setAttributeValue("incorrectBody", body);
            object.set("actualBodyTimeStamp", "" + object.getTimeStamp());
        }
    }

    public void reloadProcess(XModelObject object) {
        Document doc2;
        String bodyAux;
        StrutsProcessImpl process = (StrutsProcessImpl)object.getChildByPath("process");
        if (process == null) {
            return;
        }
        process.setReference(object);
        if (!object.isActive()) {
            return;
        }
        String string = bodyAux = object.getParent() == null ? null : this.aux.read(object.getParent(), object);
        if (bodyAux != null && (doc2 = XMLUtil.getDocument((Reader)new StringReader(bodyAux))) != null) {
            this.sputil.load(doc2.getDocumentElement(), (XModelObject)process);
        }
        process.setReference(null);
        process.firePrepared();
    }

    public boolean saveLayout(XModelObject object) {
        XModelObject process;
        block3: {
            try {
                process = object.getChildByPath("process");
                if (process != null) break block3;
                return true;
            }
            catch (Exception exc) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)exc);
                return false;
            }
        }
        process.setModified(true);
        Element element = XMLUtil.createDocumentElement((String)"PROCESS");
        this.sputil.saveAttributes(element, process);
        this.sputil.saveChildren(element, process);
        StringWriter sw = new StringWriter();
        XModelObjectLoaderUtil.serialize((Element)element, (Writer)sw);
        XModelObjectLoaderUtil.setTempBody((XModelObject)process, (String)sw.toString());
        this.aux.write(object.getParent(), object, process);
        return true;
    }

    public String serializeMainObject(XModelObject object) {
        String entity = object.getModelEntity().getName();
        int version = this.getVersion(entity);
        String systemId = object.getAttributeValue("systemId");
        if (systemId == null || systemId.length() == 0) {
            systemId = version == 10 ? "http://jakarta.apache.org/struts/dtds/struts-config_1_0.dtd" : (version == 12 ? "http://struts.apache.org/dtds/struts-config_1_2.dtd" : "http://jakarta.apache.org/struts/dtds/struts-config_1_1.dtd");
        }
        String xmlname = object.getModelEntity().getXMLSubPath();
        String publicId = version == 10 ? "-//Apache Software Foundation//DTD Struts Configuration 1.0//EN" : (version == 12 ? "-//Apache Software Foundation//DTD Struts Configuration 1.2//EN" : "-//Apache Software Foundation//DTD Struts Configuration 1.1//EN");
        Element element = XMLUtil.createDocumentElement((String)xmlname, (String)"struts-config", (String)publicId, (String)systemId, null);
        try {
            this.util.setup(null, false);
            String att = object.getAttributeValue("id");
            if (att.length() > 0) {
                this.util.saveAttribute(element, "id", att);
            }
            if ((att = object.getAttributeValue("comment")).length() > 0) {
                this.util.saveAttribute(element, "#comment", att);
            }
            this.util.saveChildren(element, object);
            if (version != 10) {
                this.util.saveChildren(element, object.getChildren("StrutsMessageResourcesFolder11")[0]);
                this.util.saveChildren(element, object.getChildren("StrutsPluginFolder11")[0]);
            }
            return SimpleWebFileLoader.serialize((Element)element, (XModelObject)object);
        }
        catch (Exception e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }
}

