/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.types.build;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.jboss.ant.targets.AbstractTargetDefinitionTarget;
import org.jboss.ant.targets.ArtifactsTarget;
import org.jboss.ant.targets.BuildTarget;
import org.jboss.ant.targets.ComponentsTarget;
import org.jboss.ant.targets.MainTarget;
import org.jboss.ant.targets.ShowTarget;
import org.jboss.ant.types.ComponentRef;
import org.jboss.ant.types.DynamicType;
import org.jboss.ant.types.Includes;
import org.jboss.ant.types.Source;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.types.deployment.Profile;
import org.jboss.ant.types.target.TargetDefinition;
import org.jboss.ant.types.target.TargetDefinitions;
import org.jboss.ant.util.FileUtil;
import org.jboss.ant.util.ReferenceUtil;
import org.jboss.ant.util.graph.Graph;

public class Build
extends Source {
    private boolean isBuild;
    private File buildFile;
    private File mainBuildFile;
    private Graph graph;
    private Vector components = new Vector();
    private Vector componentrefs = new Vector();
    private Vector profiles = new Vector();
    private String cvsRoot;
    private String location;
    private Hashtable targetMap = new Hashtable();
    private String outputPath = "output";
    private String sourcePath = "src";
    private String classesPath = "classes";
    private String resourcePath = "resources";
    private String resourceOutputPath = "resources";
    private String generatedSourceOutputPath = "gen-src";
    private String libPath = "lib";
    private String apiPath = "api";
    private String binPath = "bin";
    private String dtdPath = "resources/dtd";
    private String schemaPath = "resources/schema";
    private String testPath = "reports";
    private String thirdpartyPath = "thirdparty";
    private String specVendor;
    private String specTitle;
    private String specVersion;
    private String implVendor = "UNSPECIFIED";
    private String implTitle = "UNSPECIFED";
    private String implVersion = "UNSPECIFED";
    private String implURL = "UNSPECIFED";
    private static Build buildInstance;

    public static Build getBuild() {
        return buildInstance;
    }

    public Build() {
        if (buildInstance != null) {
            throw new BuildException("Duplicate build");
        }
        buildInstance = this;
    }

    public boolean isBuild() {
        return this.isBuild;
    }

    public boolean isStandalone() {
        return this.mainBuildFile == null;
    }

    public Vector getComponents() {
        return this.components;
    }

    public void addComponent(Component component) {
        this.components.add(component);
        component.setBuild(this);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Add component: " + component.toShortString());
        }
    }

    public void addProfile(Profile profile) {
        this.profiles.add(profile);
    }

    public boolean componentExists(Component component) {
        for (int i = 0; i < this.components.size(); ++i) {
            Component currentComponent = (Component)((Object)this.components.elementAt(i));
            if (currentComponent != component) continue;
            return true;
        }
        return false;
    }

    public Vector getComponentRefs() {
        return this.componentrefs;
    }

    public void addComponentRef(ComponentRef componentref) {
        this.componentrefs.add(componentref);
        componentref.setBuild(this);
    }

    public void addIncludes(Includes includes) {
    }

    public Vector getTargetDefinitions() {
        return this.resolveTargetDefinitions().getTargetDefinitions();
    }

    public File getBuildFile() {
        return this.buildFile;
    }

    public File getMainBuildFile() {
        return this.mainBuildFile;
    }

    public File getDir() {
        if (this.mainBuildFile != null) {
            return this.mainBuildFile.getParentFile();
        }
        return this.getBuildFile().getParentFile();
    }

    public File getThirdparty() {
        return FileUtil.resolve(this.getDir(), this.getThirdpartyPath());
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public String getReleaseName() {
        String version = this.getImplVersion();
        if (version != null) {
            return this.getId() + "-" + this.getImplVersion();
        }
        return this.getId();
    }

    public File getReleaseDir() {
        return FileUtil.resolve(this.getOutput(), this.getReleaseName());
    }

    public String getThirdpartyPath() {
        return this.thirdpartyPath;
    }

    public void setThirdpartyPath(String thirdpartyPath) {
        this.thirdpartyPath = thirdpartyPath;
        if (this.log.isTraceEnabled()) {
            this.log.trace("SET: thirdpartypath " + thirdpartyPath);
        }
    }

    public String getDependencyTargetName(String targetName) {
        AbstractTargetDefinitionTarget componentsTarget = (AbstractTargetDefinitionTarget)((Object)this.targetMap.get(targetName));
        if (componentsTarget == null) {
            return null;
        }
        return componentsTarget.getName();
    }

    public String getCvsroot() {
        return this.cvsRoot;
    }

    public void setCvsroot(String cvsRoot) {
        this.cvsRoot = cvsRoot;
    }

    public URL getLocation() throws MalformedURLException {
        if (this.location == null) {
            return null;
        }
        return new URL(this.location);
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getSpecTitle() {
        if (this.specTitle == null) {
            return this.implTitle;
        }
        return this.specTitle;
    }

    public void setSpecTitle(String title) {
        this.specTitle = title;
    }

    public String getSpecVersion() {
        if (this.specVersion == null) {
            return this.implVersion;
        }
        return this.specVersion;
    }

    public void setSpecVersion(String version) {
        this.specVersion = version;
    }

    public String getSpecVendor() {
        if (this.specVendor == null) {
            return this.implVendor;
        }
        return this.specVendor;
    }

    public void setSpecVendor(String vendor) {
        this.specVendor = vendor;
    }

    public String getImplTitle() {
        return this.implTitle;
    }

    public void setImplTitle(String title) {
        this.implTitle = title;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public void setImplVersion(String version) {
        this.implVersion = version;
    }

    public String getImplVendor() {
        return this.implVendor;
    }

    public void setImplVendor(String vendor) {
        this.implVendor = vendor;
    }

    public String getImplURL() {
        return this.implURL;
    }

    public void setImplURL(String url) {
        this.implURL = url;
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public File getOutput() {
        File result = super.getOutput();
        if (result == null) {
            result = FileUtil.resolve(this.getDir(), this.getOutputPath());
        }
        return result;
    }

    public void generate() {
        this.validate();
        if (this.isBuild()) {
            this.generateBuildTargets();
            this.generateComponentTargets();
        } else if (this.isStandalone()) {
            this.generateStandaloneTargets();
            this.generateComponentTargets();
        }
        this.addTarget(new ShowTarget(this));
    }

    protected void doValidate() {
        if (this.getId() == null) {
            throw new BuildException("Build has no id/name");
        }
        this.resolveTargetDefinitions().validate();
        this.validate(this.components);
        this.validate(this.componentrefs);
        this.validate(this.profiles);
    }

    protected void toString(StringBuffer buffer) {
        super.toString(buffer);
        buffer.append(" components=").append(this.components);
        buffer.append(" cvsRoot=").append(this.cvsRoot);
        buffer.append(" location=").append(this.location);
    }

    public void setProject(Project project) {
        if ("main.build".equals(project.getName())) {
            this.isBuild = true;
        }
        this.buildFile = new File(project.getProperty("ant.file"));
        String mainBuild = project.getProperty("ant.file.main.build");
        if (mainBuild != null) {
            this.mainBuildFile = new File(mainBuild);
        }
        super.setProject(project);
    }

    protected TargetDefinitions resolveTargetDefinitions() {
        return ReferenceUtil.resolveTargetDefinitions(this.getProject());
    }

    protected void generateBuildTargets() {
        if (this.log.isTraceEnabled()) {
            this.log.trace("Generating build targets");
        }
        Vector definitions = this.getTargetDefinitions();
        for (int i = 0; i < definitions.size(); ++i) {
            TargetDefinition definition = (TargetDefinition)((Object)definitions.get(i));
            String componentsAttr = "before";
            String artifactsAttr = "before";
            MainTarget mainTarget = null;
            List main = definition.getMain();
            if (main != null) {
                for (int j = 0; j < main.size(); ++j) {
                    DynamicType type = (DynamicType)((Object)main.get(j));
                    if (!type.applies((Object)this)) continue;
                    if (mainTarget == null) {
                        mainTarget = new MainTarget(this, definition);
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("Created a new main target: " + main.toString());
                        }
                        this.addTarget(mainTarget);
                    }
                    this.addDepends(mainTarget, type);
                    componentsAttr = type.getAttribute("components", componentsAttr);
                    artifactsAttr = type.getAttribute("artifacts", artifactsAttr);
                    break;
                }
            }
            ComponentsTarget componentsTarget = null;
            ArtifactsTarget artifactsTarget = null;
            if (definition.getComponent() != null) {
                componentsTarget = new ComponentsTarget(this, definition);
                this.addTarget(componentsTarget);
                this.targetMap.put(definition.getTarget(), componentsTarget);
            } else if (definition.getElement("artifact") != null) {
                artifactsTarget = new ArtifactsTarget(this, definition);
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Created a new ArtifactsTarget: " + artifactsTarget.getName());
                }
                this.addTarget(artifactsTarget);
                this.targetMap.put(definition.getTarget(), artifactsTarget);
            }
            BuildTarget target = new BuildTarget(this, definition);
            this.addTarget(target);
            if (componentsTarget != null && componentsAttr.equals("before")) {
                target.addDependency(componentsTarget.getName());
            }
            if (artifactsTarget != null && artifactsAttr.equals("before")) {
                target.addDependency(artifactsTarget.getName());
            }
            if (mainTarget != null) {
                target.addDependency(mainTarget.getName());
            }
            if (componentsTarget != null && componentsAttr.equals("after")) {
                target.addDependency(componentsTarget.getName());
            }
            if (artifactsTarget == null || !artifactsAttr.equals("after")) continue;
            target.addDependency(artifactsTarget.getName());
        }
    }

    protected void generateStandaloneTargets() {
        Vector definitions = this.getTargetDefinitions();
        for (int i = 0; i < definitions.size(); ++i) {
            TargetDefinition definition = (TargetDefinition)((Object)definitions.get(i));
            ArtifactsTarget artifactsTarget = null;
            if (definition.getElement("artifact") == null) continue;
            artifactsTarget = new ArtifactsTarget(this, definition);
            this.addTarget(artifactsTarget);
            this.targetMap.put(definition.getTarget(), artifactsTarget);
        }
    }

    protected void generateComponentTargets() {
        Vector components = this.getComponents();
        for (int i = 0; i < components.size(); ++i) {
            Component component = (Component)((Object)components.get(i));
            component.generateTargets();
        }
    }

    protected void addDependency(AbstractTargetDefinitionTarget target) {
        this.addTarget(target);
        TargetDefinition targetDefinition = target.getTargetDefinition();
        String targetName = targetDefinition.getTarget();
        AbstractTargetDefinitionTarget componentsTarget = (AbstractTargetDefinitionTarget)((Object)this.targetMap.get(targetName));
        if (componentsTarget == null) {
            this.log.warn("No build target for " + targetName);
            return;
        }
        componentsTarget.addDependency(target.getName());
        if (this.log.isTraceEnabled()) {
            this.log.trace("Added components dependency " + target.getName() + " for " + (Object)((Object)targetDefinition));
        }
    }

    public Vector getProfiles() {
        return this.profiles;
    }
}

