/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ant.targets;

import java.util.List;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.UnknownElement;
import org.jboss.ant.targets.AbstractTargetDefinitionTarget;
import org.jboss.ant.targets.DynamicTargetException;
import org.jboss.ant.types.build.Component;
import org.jboss.ant.types.target.TargetDefinition;
import org.jboss.ant.util.MacroUtil;

public class ComponentTarget
extends AbstractTargetDefinitionTarget {
    boolean executable = true;
    private boolean generated = false;

    private static String getDescription(Component component, TargetDefinition targetDefinition) {
        String description = targetDefinition.getDescription();
        if (description == null) {
            return null;
        }
        return description + " for the component " + component.getId();
    }

    public ComponentTarget(Component component, TargetDefinition targetDefinition) {
        super(component, targetDefinition.getTarget() + "." + component.getId(), ComponentTarget.getDescription(component, targetDefinition), targetDefinition);
        this.executable = component.isExecutable();
    }

    protected List getDynamicTypes() {
        return null;
    }

    public void execute() {
        if (!this.generated) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Generating target '" + this.getName() + "' ...");
            }
            this.getDataType().validate();
            this.generate();
            this.generated = true;
        }
        try {
            if (this.executable) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Executing target '" + this.getName() + "' ...");
                }
                super.execute();
            }
        }
        catch (Exception e) {
            DynamicTargetException.rethrow(this.getDataType().toShortString(), this.getName(), e);
        }
    }

    protected void generate() {
        this.invokeComponent();
    }

    public void show() {
        String componentTarget = this.getTargetDefinition().getTarget();
        Component component = (Component)this.getDataType();
        RuntimeConfigurable rc = this.createMacro("invoke");
        rc.setAttribute("dir", component.getDir().toString());
        rc.setAttribute("target", componentTarget);
        System.out.print(MacroUtil.dumpMacro((UnknownElement)rc.getProxy()));
    }

    protected void invokeComponent() {
        String componentTarget = this.getTargetDefinition().getTarget();
        if (this.log.isTraceEnabled()) {
            this.log.trace("New invokeComponent: " + this.getName() + " component target=" + componentTarget);
        }
        Component component = (Component)this.getDataType();
        RuntimeConfigurable rc = this.createMacro("invoke");
        rc.setAttribute("dir", component.getDir().toString());
        rc.setAttribute("target", componentTarget);
        this.addTask(rc);
    }
}

