/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMutationEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Node;

public class VpeDebugUtil {
    private static final SimpleDateFormat formatter = new SimpleDateFormat();

    static {
        formatter.applyPattern("hh:mm:ss.SSS");
    }

    public static void debugInfo(String msg) {
        if (Platform.inDebugMode()) {
            System.out.print(String.valueOf(formatter.format(new Date())) + ":" + msg);
        }
    }

    public static void debugVPEDnDEvents(String msg) {
        if (VpeDebug.PRINT_VISUAL_DRAGDROP_EVENT) {
            System.out.println(String.valueOf(formatter.format(new Date())) + ":" + msg);
        }
    }

    public static void printVisualEvent(nsIDOMEvent event) {
        System.out.print("<<< " + event.getType());
        if (event instanceof nsIDOMMutationEvent) {
            nsIDOMMutationEvent mutationEvent = (nsIDOMMutationEvent)event;
            System.out.print("  EventPhase: " + mutationEvent.getEventPhase());
            nsIDOMNode relatedNode = mutationEvent.getRelatedNode();
            System.out.print("  RelatedNode: " + (relatedNode == null ? null : relatedNode.getNodeName()));
            nsIDOMNode targetNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mutationEvent);
            String name = targetNode != null ? targetNode.getNodeName() : null;
            System.out.print("  TargetNode: " + name + " (" + targetNode + ")");
            System.out.print("  PrevValue: " + mutationEvent.getPrevValue().trim());
            System.out.print("  NewValue: " + mutationEvent.getNewValue().trim());
        }
        System.out.println();
    }

    public static void printSourceEvent(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int pos) {
        System.out.println(">>> eventType: " + INodeNotifier.EVENT_TYPE_STRINGS[eventType] + "  pos: " + pos + "  notifier: " + ((Node)notifier).getNodeName() + "  hashCode: " + notifier.hashCode());
        if (feature != null) {
            if (feature instanceof Node) {
                System.out.println("     feature: " + ((Node)feature).getNodeType() + " " + ((Node)feature).getNodeName() + "  hashCode: " + feature.hashCode());
            } else {
                System.out.println("     feature: " + feature);
            }
        }
        if (oldValue != null) {
            if (oldValue instanceof Node) {
                System.out.println("     oldValue: " + ((Node)oldValue).getNodeName() + "  hashCode: " + oldValue.hashCode());
            } else {
                System.out.println("     oldValue: " + oldValue);
            }
        }
        if (newValue != null) {
            if (newValue instanceof Node) {
                System.out.println("     newValue: " + ((Node)newValue).getNodeName() + "  hashCode: " + newValue.hashCode() + " " + ((Node)newValue).getNodeType());
            } else {
                System.out.println("     newValue: " + newValue);
            }
        }
    }

    public static void printKeyEvent(nsIDOMKeyEvent keyEvent) {
        System.out.println("<<< keyPress  type: " + keyEvent.getType() + "  Ctrl: " + keyEvent.getCtrlKey() + "  Shift: " + keyEvent.getShiftKey() + "  CharCode: " + keyEvent.getCharCode() + "  KeyCode: " + keyEvent.getKeyCode());
    }

    public static void printVisualMouseEvent(nsIDOMNode visualNode) {
        System.out.println("<<< mouseDblClick  visualNode: " + visualNode.getNodeName() + " (" + visualNode + ")");
    }
}

