/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.toolbar.format.handler;

import java.util.HashMap;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.template.textformating.FormatData;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.toolbar.format.handler.FormatHandler;
import org.jboss.tools.vpe.editor.toolbar.format.handler.FormatHandlerLoadingException;
import org.jboss.tools.vpe.editor.toolbar.format.handler.IAddNodeHandler;
import org.jboss.tools.vpe.editor.toolbar.format.handler.IFormatHandler;

public class HandlerFactory {
    private FormatControllerManager manager;
    private HashMap<String, IFormatHandler> handlers = new HashMap();

    public HandlerFactory(FormatControllerManager manager) {
        this.manager = manager;
    }

    public IFormatHandler createHandler(FormatData formatData) {
        String handlerClassName = formatData.getHandler();
        if (handlerClassName != null && handlerClassName.trim().length() > 0) {
            IFormatHandler object = this.handlers.get(handlerClassName);
            if (object != null) {
                return object;
            }
            try {
                Class<?> handlerClass = Class.forName(handlerClassName);
                object = handlerClass.newInstance();
                if (object instanceof IFormatHandler) {
                    IFormatHandler handler = object;
                    if (handler instanceof FormatHandler) {
                        FormatHandler formatHandler = (FormatHandler)handler;
                        formatHandler.setManager(this.manager);
                    }
                    this.handlers.put(handlerClassName, handler);
                    return handler;
                }
                VpePlugin.getPluginLog().logError("Wrong format handler. Class - " + handlerClassName + ". Handler must be instance of org.jboss.tools.vpe.editor.toolbar.format.handler.IFormatHandler", (Throwable)new FormatHandlerLoadingException("Handler must be instance of org.jboss.tools.vpe.editor.toolbar.format.handler.IFormatHandler"));
            }
            catch (IllegalAccessException e) {
                this.reportException(e, handlerClassName);
            }
            catch (InstantiationException e) {
                this.reportException(e, handlerClassName);
            }
            catch (ClassNotFoundException e) {
                this.reportException(e, handlerClassName);
            }
        }
        return null;
    }

    public IAddNodeHandler createAddNodeHandler(FormatData formatData) {
        return null;
    }

    public int getCountHandlers() {
        return this.handlers.size();
    }

    private void reportException(Exception e, String handlerClassName) {
        VpePlugin.getPluginLog().logError("Can't create format handler. Class: " + handlerClassName, (Throwable)e);
    }
}

