/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.template.VpeTemplateFile;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.osgi.framework.Bundle;

public class VpeTemplateFileList {
    private boolean changed;
    private VpeTemplateFile autoTemplateFile;
    private VpeTemplateFile[] templateFiles;

    VpeTemplateFileList() {
    }

    void load() {
        VpeTemplateFile newAutoTemplateFile = new VpeTemplateFile(VpeTemplateManager.getAutoTemplates(), null);
        this.changed = this.autoTemplateFile == null ^ newAutoTemplateFile == null;
        if (!this.changed && this.autoTemplateFile != null) {
            this.changed = !this.autoTemplateFile.isEqual(newAutoTemplateFile);
        }
        VpeTemplateFile[] newTemplateFiles = this.createTemplateFileList();
        if (!this.changed && this.templateFiles != null) {
            boolean bl = this.changed = this.templateFiles.length != newTemplateFiles.length;
            if (!this.changed) {
                int i = 0;
                while (i < this.templateFiles.length) {
                    if (!this.templateFiles[i].isEqual(newTemplateFiles[i])) {
                        this.changed = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        this.autoTemplateFile = newAutoTemplateFile;
        this.templateFiles = newTemplateFiles;
    }

    VpeTemplateFile getAutoTemplateFile() {
        return this.autoTemplateFile;
    }

    VpeTemplateFile[] getTemplateFiles() {
        return this.templateFiles;
    }

    boolean isChanged() {
        return this.changed;
    }

    private VpeTemplateFile[] createTemplateFileList() {
        List<VpeTemplateFile> templateList = this.createTemplateFileListImpl();
        return templateList.toArray(new VpeTemplateFile[templateList.size()]);
    }

    private List<VpeTemplateFile> createTemplateFileListImpl() {
        ArrayList<VpeTemplateFile> templateList = new ArrayList<VpeTemplateFile>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.jboss.tools.vpe.templates");
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                String pathAttrValue = elements[j].getAttribute("path");
                try {
                    VpeTemplateFile templateFile = new VpeTemplateFile(pathAttrValue, elements[j]);
                    templateList.add(templateFile);
                }
                catch (IOException e) {
                    VpePlugin.getPluginLog().logError("Error during loading template '" + pathAttrValue + "'", (Throwable)e);
                }
                ++j;
            }
            ++i;
        }
        return templateList;
    }

    static IPath getFilePath(String name, IConfigurationElement confElement) throws IOException {
        VpePlugin plugin = VpePlugin.getDefault();
        Bundle bundle = confElement == null ? plugin.getBundle() : Platform.getBundle((String)confElement.getContributor().getName());
        URL url = bundle.getEntry("/");
        Path path = new Path(FileLocator.toFileURL((URL)url).getFile());
        path = path.append(name);
        return path;
    }
}

