/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeCreatorUtil;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.expression.VpeExpression;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.editor.template.expression.VpeValue;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeClassUtil;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpePanelGridCreator
extends VpeAbstractCreator {
    private boolean caseSensitive;
    private VpeExpression tableSizeExpr;
    private VpeExpression captionClassExpr;
    private VpeExpression captionStyleExpr;
    private VpeExpression headerClassExpr;
    private VpeExpression footerClassExpr;
    private VpeExpression rowClassesExpr;
    private VpeExpression columnClassesExpr;
    private VpeExpression rulesExpr;
    private List propertyCreators;

    VpePanelGridCreator(Element gridElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(gridElement, dependencyMap);
    }

    private void build(Element gridElement, VpeDependencyMap dependencyMap) {
        Attr rulesAttr;
        Attr captionStyleAttr;
        Attr captionClassesAttr;
        Attr columnClassesAttr;
        Attr rowClassesAttr;
        Attr footerClassAttr;
        Attr headerClassAttr;
        Attr tableSizeAttr = gridElement.getAttributeNode("table-size");
        if (tableSizeAttr != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(tableSizeAttr.getValue(), this.caseSensitive);
                this.tableSizeExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((headerClassAttr = gridElement.getAttributeNode("headerClass")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(headerClassAttr.getValue(), this.caseSensitive);
                this.headerClassExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((footerClassAttr = gridElement.getAttributeNode("footerClass")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(footerClassAttr.getValue(), this.caseSensitive);
                this.footerClassExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((rowClassesAttr = gridElement.getAttributeNode("rowClasses")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(rowClassesAttr.getValue(), this.caseSensitive);
                this.rowClassesExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((columnClassesAttr = gridElement.getAttributeNode("columnClasses")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(columnClassesAttr.getValue(), this.caseSensitive);
                this.columnClassesExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((captionClassesAttr = gridElement.getAttributeNode("captionClass")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(captionClassesAttr.getValue(), this.caseSensitive);
                this.captionClassExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((captionStyleAttr = gridElement.getAttributeNode("captionStyle")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(captionStyleAttr.getValue(), this.caseSensitive);
                this.captionStyleExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((rulesAttr = gridElement.getAttributeNode("rules")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(rulesAttr.getValue(), this.caseSensitive);
                this.rulesExpr = info.getExpression();
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if (VpeTemplateManager.ATTR_GRID_PROPERTIES != null) {
            int i = 0;
            while (i < VpeTemplateManager.ATTR_GRID_PROPERTIES.length) {
                String attrName = VpeTemplateManager.ATTR_GRID_PROPERTIES[i];
                Attr attr = gridElement.getAttributeNode(attrName);
                if (attr != null) {
                    if (this.propertyCreators == null) {
                        this.propertyCreators = new ArrayList();
                    }
                    this.propertyCreators.add(new VpeAttributeCreator(attrName, attr.getValue(), dependencyMap, this.caseSensitive));
                }
                ++i;
            }
        }
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        NodeList children;
        int count;
        String rules;
        VpeValue vpeValue;
        int tableSize = 1;
        if (this.tableSizeExpr != null && (vpeValue = this.tableSizeExpr.exec(pageContext, sourceNode)) != null) {
            String strValue = vpeValue.stringValue();
            try {
                int val = Integer.parseInt(strValue);
                if (val > 0) {
                    tableSize = val;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        nsIDOMElement visualTable = visualDocument.createElement("table");
        VpeCreatorInfo creatorInfo = new VpeCreatorInfo((nsIDOMNode)visualTable);
        if (this.propertyCreators != null) {
            int i = 0;
            while (i < this.propertyCreators.size()) {
                VpeCreatorInfo info;
                VpeCreator creator = (VpeCreator)this.propertyCreators.get(i);
                if (creator != null && (info = creator.create(pageContext, sourceNode, visualDocument, visualTable, visualNodeMap)) != null && info.getVisualNode() != null) {
                    nsIDOMAttr attr = (nsIDOMAttr)info.getVisualNode();
                    visualTable.setAttributeNode(attr);
                }
                ++i;
            }
        }
        if (this.rulesExpr != null && (rules = this.rulesExpr.exec(pageContext, sourceNode).stringValue()).length() > 0) {
            visualTable.setAttribute("rules", rules);
        }
        int n = count = (children = sourceNode.getChildNodes()) != null ? children.getLength() : 0;
        if (count > 0) {
            Node header = null;
            Node footer = null;
            Node caption = null;
            Node[] sourceChildren = new Node[count];
            int childrenCount = 0;
            int i = 0;
            while (i < count) {
                Node node = children.item(i);
                short type = node.getNodeType();
                if (type == 1 || type == 3 && node.getNodeValue() != null && node.getNodeValue().trim().length() > 0) {
                    switch (VpeCreatorUtil.getFacetType(node, pageContext)) {
                        case 1: {
                            header = node;
                            break;
                        }
                        case 2: {
                            footer = node;
                            break;
                        }
                        case 5: {
                            caption = node;
                            break;
                        }
                        default: {
                            sourceChildren[childrenCount] = node;
                            ++childrenCount;
                        }
                    }
                }
                ++i;
            }
            if (childrenCount > 0) {
                if (tableSize == 0) {
                    tableSize = childrenCount;
                }
                Map<String, List<Node>> captionFacetChildren = null;
                Map<String, List<Node>> headerFacetChildren = null;
                Map<String, List<Node>> footerFacetChildren = null;
                captionFacetChildren = VisualDomUtil.findFacetElements(caption, pageContext);
                headerFacetChildren = VisualDomUtil.findFacetElements(header, pageContext);
                footerFacetChildren = VisualDomUtil.findFacetElements(footer, pageContext);
                boolean captionHtmlElementsPresents = captionFacetChildren != null && captionFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS).size() > 0;
                boolean headerHtmlElementsPresents = headerFacetChildren != null && headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS).size() > 0;
                boolean footerHtmlElementsPresents = footerFacetChildren != null && footerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS).size() > 0;
                boolean htmlFacetsElementsPresents = captionHtmlElementsPresents || headerHtmlElementsPresents || footerHtmlElementsPresents;
                boolean htmlFacetsElementsRendered = false;
                if (htmlFacetsElementsPresents) {
                    ++childrenCount;
                }
                int rowCount = (childrenCount + tableSize - 1) / tableSize;
                nsIDOMElement visualHead = null;
                nsIDOMElement visualFoot = null;
                nsIDOMElement visualCaption = null;
                if (caption != null) {
                    visualCaption = visualDocument.createElement("caption");
                    visualTable.appendChild((nsIDOMNode)visualCaption);
                    VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualCaption);
                    childrenInfo.addSourceChild(caption);
                    creatorInfo.addChildrenInfo(childrenInfo);
                    if (this.captionClassExpr != null && caption.getParentNode() != null) {
                        String captionClass = this.captionClassExpr.exec(pageContext, caption.getParentNode()).stringValue();
                        visualCaption.setAttribute("class", captionClass);
                    }
                    if (this.captionStyleExpr != null && caption.getParentNode() != null) {
                        String captionStyle = this.captionStyleExpr.exec(pageContext, caption.getParentNode()).stringValue();
                        visualCaption.setAttribute("style", captionStyle);
                    }
                }
                if (header != null) {
                    visualHead = visualDocument.createElement("thead");
                    visualTable.appendChild((nsIDOMNode)visualHead);
                }
                if (footer != null) {
                    visualFoot = visualDocument.createElement("tfoot");
                    visualTable.appendChild((nsIDOMNode)visualFoot);
                }
                nsIDOMElement visualBody = visualDocument.createElement("tbody");
                visualTable.appendChild((nsIDOMNode)visualBody);
                List<String> rowClasses = VpeClassUtil.getClasses(this.rowClassesExpr, sourceNode, pageContext);
                List<String> columnClasses = VpeClassUtil.getClasses(this.columnClassesExpr, sourceNode, pageContext);
                int rci = 0;
                int i2 = 0;
                while (i2 < rowCount) {
                    int cci = 0;
                    nsIDOMElement visualRow = visualDocument.createElement("tr");
                    if (!rowClasses.isEmpty()) {
                        visualRow.setAttribute("class", rowClasses.get(rci).toString());
                        if (++rci >= rowClasses.size()) {
                            rci = 0;
                        }
                    }
                    int j = 0;
                    while (j < tableSize) {
                        if (i2 * tableSize + j >= childrenCount) break;
                        nsIDOMElement visualCell = visualDocument.createElement("td");
                        if (!columnClasses.isEmpty()) {
                            visualCell.setAttribute("class", columnClasses.get(cci).toString());
                            if (++cci >= columnClasses.size()) {
                                cci = 0;
                            }
                        }
                        visualRow.appendChild((nsIDOMNode)visualCell);
                        if (htmlFacetsElementsPresents && !htmlFacetsElementsRendered) {
                            VpeChildrenInfo childrenInfo = null;
                            if (captionHtmlElementsPresents) {
                                for (Node node : captionFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                                    childrenInfo = new VpeChildrenInfo(visualCell);
                                    childrenInfo.addSourceChild(node);
                                    creatorInfo.addChildrenInfo(childrenInfo);
                                }
                            }
                            if (headerHtmlElementsPresents) {
                                for (Node node : headerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                                    childrenInfo = new VpeChildrenInfo(visualCell);
                                    childrenInfo.addSourceChild(node);
                                    creatorInfo.addChildrenInfo(childrenInfo);
                                }
                            }
                            if (footerHtmlElementsPresents) {
                                for (Node node : footerFacetChildren.get(VisualDomUtil.FACET_HTML_TAGS)) {
                                    childrenInfo = new VpeChildrenInfo(visualCell);
                                    childrenInfo.addSourceChild(node);
                                    creatorInfo.addChildrenInfo(childrenInfo);
                                }
                            }
                            htmlFacetsElementsRendered = true;
                        } else {
                            int sourceIndex = tableSize * i2 + j;
                            if (sourceIndex < childrenCount) {
                                Node child;
                                if (htmlFacetsElementsPresents) {
                                    --sourceIndex;
                                }
                                if ((child = sourceChildren[sourceIndex]) != header && child != footer) {
                                    VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualCell);
                                    childrenInfo.addSourceChild(child);
                                    creatorInfo.addChildrenInfo(childrenInfo);
                                }
                            }
                        }
                        ++j;
                    }
                    if (visualBody != null) {
                        visualBody.appendChild((nsIDOMNode)visualRow);
                    } else {
                        visualTable.appendChild((nsIDOMNode)visualRow);
                    }
                    ++i2;
                }
                this.makeSpecial(header, "header", visualHead, visualDocument, tableSize, creatorInfo, "th", this.headerClassExpr, pageContext);
                this.makeSpecial(footer, "footer", visualFoot, visualDocument, tableSize, creatorInfo, "td", this.footerClassExpr, pageContext);
                i2 = 0;
                while (i2 < this.propertyCreators.size()) {
                    nsIDOMAttr attr;
                    VpeCreatorInfo info;
                    VpeCreator creator = (VpeCreator)this.propertyCreators.get(i2);
                    if (creator != null && (info = creator.create(pageContext, sourceNode, visualDocument, visualTable, visualNodeMap)) != null && info.getVisualNode() != null && (attr = (nsIDOMAttr)info.getVisualNode()).getValue().length() > 0) {
                        visualTable.setAttributeNode(attr);
                    }
                    ++i2;
                }
            }
        }
        return creatorInfo;
    }

    private void makeSpecial(Node facet, String facetName, nsIDOMElement visualHead, nsIDOMDocument visualDocument, int tableSize, VpeCreatorInfo creatorInfo, String cellTag, VpeExpression headerClassExpr, VpePageContext pageContext) throws VpeExpressionException {
        if (facet != null && visualHead != null) {
            nsIDOMElement visualRow = visualDocument.createElement("tr");
            visualHead.appendChild((nsIDOMNode)visualRow);
            nsIDOMElement visualCell = visualDocument.createElement(cellTag);
            visualCell.setAttribute("colspan", "" + tableSize);
            if (headerClassExpr != null && facet.getParentNode() != null) {
                String headerClass = headerClassExpr.exec(pageContext, facet.getParentNode()).stringValue();
                visualCell.setAttribute("class", headerClass);
            }
            visualRow.appendChild((nsIDOMNode)visualCell);
            VpeChildrenInfo childrenInfo = new VpeChildrenInfo(visualCell);
            childrenInfo.addSourceChild(facet);
            creatorInfo.addChildrenInfo(childrenInfo);
            visualCell.setAttribute("VPE-FACET", facetName);
        }
    }

    private Node getFirstChildElement(Node parentNode) {
        if (parentNode != null) {
            NodeList childrens = parentNode.getChildNodes();
            int length = childrens != null ? childrens.getLength() : 0;
            int i = 0;
            while (i < length) {
                Node child = childrens.item(i);
                if (child.getNodeType() == 1) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public boolean isRecreateAtAttrChange(VpePageContext pageContext, Element sourceElement, nsIDOMDocument visualDocument, nsIDOMNode visualNode, Object data, String name, String value) {
        return true;
    }
}

