/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;
import org.jboss.forge.parser.java.Field;
import org.jboss.forge.parser.java.FieldHolder;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.Method;
import org.jboss.forge.parser.java.MethodHolder;
import org.jboss.forge.parser.java.Parameter;
import org.jboss.forge.parser.java.ast.MethodFinderVisitor;
import org.jboss.forge.parser.java.impl.AbstractJavaSource;
import org.jboss.forge.parser.java.impl.FieldImpl;
import org.jboss.forge.parser.java.impl.MethodImpl;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;

public abstract class AbstractJavaSourceMemberHolder<O extends JavaSource<O>>
extends AbstractJavaSource<O>
implements MethodHolder<O>,
FieldHolder<O> {
    public AbstractJavaSourceMemberHolder(Document document, CompilationUnit unit) {
        super(document, unit);
    }

    public Field<O> addField() {
        FieldImpl<AbstractJavaSourceMemberHolder> field = new FieldImpl<AbstractJavaSourceMemberHolder>(this);
        this.getBodyDeclaration().bodyDeclarations().add(field.getInternal());
        return field;
    }

    public Field<O> addField(String declaration) {
        FieldImpl<AbstractJavaSourceMemberHolder> field = new FieldImpl<AbstractJavaSourceMemberHolder>(this, declaration);
        this.getBodyDeclaration().bodyDeclarations().add(field.getInternal());
        return field;
    }

    @Override
    public List<Member<O, ?>> getMembers() {
        ArrayList result = new ArrayList();
        result.addAll(this.getFields());
        result.addAll(this.getMethods());
        return result;
    }

    public List<Field<O>> getFields() {
        ArrayList<FieldImpl<AbstractJavaSourceMemberHolder>> result = new ArrayList<FieldImpl<AbstractJavaSourceMemberHolder>>();
        for (FieldDeclaration field : ((TypeDeclaration)this.getBodyDeclaration()).getFields()) {
            result.add(new FieldImpl<AbstractJavaSourceMemberHolder>(this, field));
        }
        return Collections.unmodifiableList(result);
    }

    public Field<O> getField(String name) {
        for (Field<O> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public boolean hasField(String name) {
        for (Field<O> field : this.getFields()) {
            if (!field.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasField(Field<O> field) {
        return this.getFields().contains(field);
    }

    public O removeField(Field<O> field) {
        this.getBodyDeclaration().bodyDeclarations().remove(field.getInternal());
        return (O)this;
    }

    public boolean hasMethod(Method<O> method) {
        return this.getMethods().contains(method);
    }

    public boolean hasMethodSignature(String name) {
        return this.hasMethodSignature(name, new String[0]);
    }

    public boolean hasMethodSignature(String name, String ... paramTypes) {
        return this.getMethod(name, paramTypes) != null;
    }

    public boolean hasMethodSignature(String name, Class<?> ... paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String[] types = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.hasMethodSignature(name, types);
    }

    public Method<O> getMethod(String name) {
        for (Method<O> method : this.getMethods()) {
            if (!method.getName().equals(name) || method.getParameters().size() != 0) continue;
            return method;
        }
        return null;
    }

    public Method<O> getMethod(String name, String ... paramTypes) {
        for (Method<O> local : this.getMethods()) {
            if (!local.getName().equals(name)) continue;
            List localParams = local.getParameters();
            if ((paramTypes == null || localParams.size() != 0) && localParams.size() != paramTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < localParams.size(); ++i) {
                Parameter localParam = (Parameter)localParams.get(i);
                String type = paramTypes[i];
                if (Types.areEquivalent((String)localParam.getType(), (String)type)) continue;
                matches = false;
            }
            if (!matches) continue;
            return local;
        }
        return null;
    }

    public Method<O> getMethod(String name, Class<?> ... paramTypes) {
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        String[] types = new String[paramTypes.length];
        for (int i = 0; i < paramTypes.length; ++i) {
            types[i] = paramTypes[i].getName();
        }
        return this.getMethod(name, types);
    }

    public boolean hasMethodSignature(Method<?> method) {
        for (Method<O> local : this.getMethods()) {
            if (!local.getName().equals(method.getName())) continue;
            List localParams = local.getParameters();
            List methodParams = method.getParameters();
            if (localParams.size() != methodParams.size()) continue;
            for (int i = 0; i < localParams.size(); ++i) {
                Parameter localParam = (Parameter)localParams.get(i);
                Parameter methodParam = (Parameter)methodParams.get(i);
                if (Strings.areEqual((String)localParam.getType(), (String)methodParam.getType())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public O removeMethod(Method<O> method) {
        this.getBodyDeclaration().bodyDeclarations().remove(method.getInternal());
        return (O)this;
    }

    public Method<O> addMethod() {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this);
        this.getBodyDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public Method<O> addMethod(String method) {
        MethodImpl<AbstractJavaSourceMemberHolder> m = new MethodImpl<AbstractJavaSourceMemberHolder>(this, method);
        this.getBodyDeclaration().bodyDeclarations().add(m.getInternal());
        return m;
    }

    public List<Method<O>> getMethods() {
        ArrayList<MethodImpl<AbstractJavaSourceMemberHolder>> result = new ArrayList<MethodImpl<AbstractJavaSourceMemberHolder>>();
        MethodFinderVisitor methodFinderVisitor = new MethodFinderVisitor();
        this.unit.accept((ASTVisitor)methodFinderVisitor);
        List<MethodDeclaration> methods = methodFinderVisitor.getMethods();
        for (MethodDeclaration methodDeclaration : methods) {
            result.add(new MethodImpl<AbstractJavaSourceMemberHolder>(this, methodDeclaration));
        }
        return Collections.unmodifiableList(result);
    }
}

