/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.jboss.forge.parser.JavaParser;
import org.jboss.forge.parser.ParserException;
import org.jboss.forge.parser.java.Annotation;
import org.jboss.forge.parser.java.AnnotationTarget;
import org.jboss.forge.parser.java.Import;
import org.jboss.forge.parser.java.InterfaceCapable;
import org.jboss.forge.parser.java.JavaInterface;
import org.jboss.forge.parser.java.JavaSource;
import org.jboss.forge.parser.java.Member;
import org.jboss.forge.parser.java.SyntaxError;
import org.jboss.forge.parser.java.Visibility;
import org.jboss.forge.parser.java.VisibilityScoped;
import org.jboss.forge.parser.java.ast.AnnotationAccessor;
import org.jboss.forge.parser.java.ast.ModifierAccessor;
import org.jboss.forge.parser.java.ast.TypeDeclarationFinderVisitor;
import org.jboss.forge.parser.java.impl.ImportImpl;
import org.jboss.forge.parser.java.impl.JDTHelper;
import org.jboss.forge.parser.java.impl.JavaInterfaceImpl;
import org.jboss.forge.parser.java.impl.SyntaxErrorImpl;
import org.jboss.forge.parser.java.util.Formatter;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.parser.java.util.Types;
import org.jboss.forge.parser.spi.WildcardImportResolver;

public abstract class AbstractJavaSource<O extends JavaSource<O>>
implements JavaSource<O>,
InterfaceCapable<O> {
    private final AnnotationAccessor<O, O> annotations = new AnnotationAccessor();
    private final ModifierAccessor modifiers = new ModifierAccessor();
    private final Document document;
    protected CompilationUnit unit;
    public static ServiceLoader<WildcardImportResolver> loader = ServiceLoader.load(WildcardImportResolver.class);
    private static List<WildcardImportResolver> resolvers;

    public AbstractJavaSource(Document document, CompilationUnit unit) {
        this.document = document;
        this.unit = unit;
    }

    public Annotation<O> addAnnotation() {
        return this.annotations.addAnnotation((AnnotationTarget<O, O>)this, (BodyDeclaration)this.getBodyDeclaration());
    }

    public Annotation<O> addAnnotation(Class<? extends java.lang.annotation.Annotation> clazz) {
        return this.annotations.addAnnotation((AnnotationTarget<O, O>)this, (BodyDeclaration)this.getBodyDeclaration(), clazz.getName());
    }

    public Annotation<O> addAnnotation(String className) {
        return this.annotations.addAnnotation((AnnotationTarget<O, O>)this, (BodyDeclaration)this.getBodyDeclaration(), className);
    }

    public List<Annotation<O>> getAnnotations() {
        return this.annotations.getAnnotations((AnnotationTarget<O, O>)this, (BodyDeclaration)this.getBodyDeclaration());
    }

    public boolean hasAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.hasAnnotation(this, (BodyDeclaration)this.getBodyDeclaration(), type.getName());
    }

    public boolean hasAnnotation(String type) {
        return this.annotations.hasAnnotation(this, (BodyDeclaration)this.getBodyDeclaration(), type);
    }

    public O removeAnnotation(Annotation<O> annotation) {
        return (O)this.annotations.removeAnnotation(this, (BodyDeclaration)this.getBodyDeclaration(), annotation);
    }

    public Annotation<O> getAnnotation(Class<? extends java.lang.annotation.Annotation> type) {
        return this.annotations.getAnnotation((AnnotationTarget<O, O>)this, (BodyDeclaration)this.getBodyDeclaration(), (Class<java.lang.annotation.Annotation>)type);
    }

    public Annotation<O> getAnnotation(String type) {
        return this.annotations.getAnnotation((AnnotationTarget<O, O>)this, (BodyDeclaration)this.getBodyDeclaration(), type);
    }

    public Import addImport(Class<?> type) {
        return this.addImport(type.getName());
    }

    public <T extends JavaSource<?>> Import addImport(T type) {
        return this.addImport(type.getQualifiedName());
    }

    public Import addImport(Import imprt) {
        return this.addImport(imprt.getQualifiedName()).setStatic(imprt.isStatic());
    }

    public Import addImport(String className) {
        Import imprt;
        String simpleName = Types.toSimpleName((String)className);
        if (!this.hasImport(simpleName) && this.validImport(className)) {
            imprt = new ImportImpl(this).setName(className);
            this.unit.imports().add(imprt.getInternal());
        } else if (this.hasImport(className)) {
            imprt = this.getImport(className);
        } else {
            if (this.hasImport(simpleName)) {
                throw new IllegalStateException("Cannot import [" + className + "] because of existing conflicting import [" + this.getImport(simpleName) + "].");
            }
            throw new IllegalArgumentException("Attempted to import the illegal type [" + className + "]");
        }
        return imprt;
    }

    public Import getImport(String className) {
        List<Import> imports = this.getImports();
        for (Import imprt : imports) {
            if (!imprt.getQualifiedName().equals(className) && !imprt.getSimpleName().equals(className)) continue;
            return imprt;
        }
        return null;
    }

    public Import getImport(Class<?> type) {
        return this.getImport(type.getName());
    }

    public <T extends JavaSource<?>> Import getImport(T type) {
        return this.getImport(type.getQualifiedName());
    }

    public Import getImport(Import imprt) {
        return this.getImport(imprt.getQualifiedName());
    }

    public List<Import> getImports() {
        ArrayList<ImportImpl> results = new ArrayList<ImportImpl>();
        for (ImportDeclaration i : this.unit.imports()) {
            results.add(new ImportImpl(this, i));
        }
        return Collections.unmodifiableList(results);
    }

    public boolean hasImport(Class<?> type) {
        return this.hasImport(type.getName());
    }

    public <T extends JavaSource<T>> boolean hasImport(T type) {
        return this.hasImport(type.getQualifiedName());
    }

    public boolean hasImport(Import imprt) {
        return this.hasImport(imprt.getQualifiedName());
    }

    public boolean hasImport(String type) {
        return this.getImport(type) != null;
    }

    public boolean requiresImport(Class<?> type) {
        return this.requiresImport(type.getName());
    }

    public boolean requiresImport(String type) {
        return this.validImport(type) && !this.hasImport(type) && !type.startsWith("java.lang.");
    }

    public String resolveType(String type) {
        String original = type;
        String result = type;
        if (Types.isPrimitive((String)result)) {
            return result;
        }
        if (Types.isArray((String)result)) {
            original = Types.stripArray((String)result);
            result = Types.stripArray((String)result);
        }
        if (Types.isGeneric((String)result)) {
            original = Types.stripGenerics((String)result);
            result = Types.stripGenerics((String)result);
        }
        if (Types.isSimpleName((String)result)) {
            if (!this.hasImport(type) && Types.isJavaLang((String)type)) {
                result = "java.lang." + result;
            }
            if (result.equals(original)) {
                for (Import imprt : this.getImports()) {
                    if (!Types.areEquivalent((String)result, (String)imprt.getQualifiedName())) continue;
                    result = imprt.getQualifiedName();
                    break;
                }
            }
        }
        if (Types.isSimpleName((String)result)) {
            for (Import imprt : this.getImports()) {
                WildcardImportResolver r;
                if (!imprt.isWildcard()) continue;
                Iterator<WildcardImportResolver> i$ = this.getImportResolvers().iterator();
                while (i$.hasNext() && !Types.isQualified((String)(result = (r = i$.next()).resolve((JavaSource)this, result)))) {
                }
            }
        }
        if (Types.isSimpleName((String)result) && this.getPackage() != null) {
            result = this.getPackage() + "." + result;
        }
        return result;
    }

    private List<WildcardImportResolver> getImportResolvers() {
        if (resolvers == null) {
            resolvers = new ArrayList<WildcardImportResolver>();
            for (WildcardImportResolver r : resolvers) {
                resolvers.add(r);
            }
        }
        if (resolvers.size() == 0) {
            throw new IllegalStateException("No instances of [" + WildcardImportResolver.class.getName() + "] were found on the classpath.");
        }
        return resolvers;
    }

    private boolean validImport(String type) {
        return type != null && !type.matches("byte|short|int|long|float|double|char|boolean");
    }

    public O removeImport(String name) {
        for (Import i : this.getImports()) {
            if (!i.getQualifiedName().equals(name)) continue;
            this.removeImport(i);
            break;
        }
        return (O)this;
    }

    public O removeImport(Class<?> clazz) {
        return this.removeImport((JavaSource)clazz.getName());
    }

    public <T extends JavaSource<?>> O removeImport(T type) {
        return this.removeImport((T)type.getQualifiedName());
    }

    public O removeImport(Import imprt) {
        Object internal = imprt.getInternal();
        if (this.unit.imports().contains(internal)) {
            this.unit.imports().remove(internal);
        }
        return (O)this;
    }

    public List<Member<O, ?>> getMembers() {
        ArrayList result = new ArrayList();
        return result;
    }

    protected AbstractTypeDeclaration getBodyDeclaration() {
        TypeDeclarationFinderVisitor typeDeclarationFinder = new TypeDeclarationFinderVisitor();
        this.unit.accept((ASTVisitor)typeDeclarationFinder);
        AbstractTypeDeclaration declaration = typeDeclarationFinder.getTypeDeclaration();
        if (declaration == null) {
            throw new RuntimeException("A type-declaration is required in order to complete the current operation, but no type-declaration exists in compilation unit: " + this.unit.toString());
        }
        return declaration;
    }

    public String getName() {
        return this.getBodyDeclaration().getName().getIdentifier();
    }

    public O setName(String name) {
        this.getBodyDeclaration().setName(this.unit.getAST().newSimpleName(name));
        return this.updateTypeNames(name);
    }

    protected abstract O updateTypeNames(String var1);

    public String getQualifiedName() {
        String packg = this.getPackage();
        String name = this.getName();
        if (packg != null && !packg.isEmpty()) {
            return packg + "." + name;
        }
        return name;
    }

    public String getPackage() {
        PackageDeclaration pkg = this.unit.getPackage();
        if (pkg != null) {
            return pkg.getName().getFullyQualifiedName();
        }
        return null;
    }

    public O setPackage(String name) {
        if (this.unit.getPackage() == null) {
            this.unit.setPackage(this.unit.getAST().newPackageDeclaration());
        }
        this.unit.getPackage().setName(this.unit.getAST().newName(name));
        return (O)this;
    }

    public O setDefaultPackage() {
        this.unit.setPackage(null);
        return (O)this;
    }

    public boolean isDefaultPackage() {
        return this.unit.getPackage() == null;
    }

    public boolean isPackagePrivate() {
        return !this.isPublic() && !this.isPrivate() && !this.isProtected();
    }

    public O setPackagePrivate() {
        this.modifiers.clearVisibility((BodyDeclaration)this.getBodyDeclaration());
        return (O)this;
    }

    public boolean isPublic() {
        return this.modifiers.hasModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
    }

    public O setPublic() {
        this.modifiers.clearVisibility((BodyDeclaration)this.getBodyDeclaration());
        this.modifiers.addModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.PUBLIC_KEYWORD);
        return (O)this;
    }

    public boolean isPrivate() {
        return this.modifiers.hasModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
    }

    public O setPrivate() {
        this.modifiers.clearVisibility((BodyDeclaration)this.getBodyDeclaration());
        this.modifiers.addModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.PRIVATE_KEYWORD);
        return (O)this;
    }

    public boolean isProtected() {
        return this.modifiers.hasModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
    }

    public O setProtected() {
        this.modifiers.clearVisibility((BodyDeclaration)this.getBodyDeclaration());
        this.modifiers.addModifier((BodyDeclaration)this.getBodyDeclaration(), Modifier.ModifierKeyword.PROTECTED_KEYWORD);
        return (O)this;
    }

    public Visibility getVisibility() {
        return Visibility.getFrom((VisibilityScoped)this);
    }

    public O setVisibility(Visibility scope) {
        return (O)((JavaSource)Visibility.set((VisibilityScoped)this, (Visibility)scope));
    }

    public String toString() {
        Document document = new Document(this.document.get());
        try {
            TextEdit edit = this.unit.rewrite((IDocument)document, null);
            edit.apply((IDocument)document);
        }
        catch (Exception e) {
            throw new ParserException("Could not modify source: " + this.unit.toString(), (Throwable)e);
        }
        return Formatter.format(document.get());
    }

    public Object getInternal() {
        return this.unit;
    }

    public O getOrigin() {
        return (O)this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.toString() == null ? 0 : this.unit.toString().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.toString().equals(obj.toString());
    }

    public List<SyntaxError> getSyntaxErrors() {
        ArrayList<SyntaxError> result = new ArrayList<SyntaxError>();
        IProblem[] problems = this.unit.getProblems();
        if (problems != null) {
            for (IProblem problem : problems) {
                result.add(new SyntaxErrorImpl(this, problem));
            }
        }
        return result;
    }

    public boolean hasSyntaxErrors() {
        return !this.getSyntaxErrors().isEmpty();
    }

    public boolean isClass() {
        AbstractTypeDeclaration declaration = this.getBodyDeclaration();
        return declaration instanceof TypeDeclaration && !((TypeDeclaration)declaration).isInterface();
    }

    public boolean isEnum() {
        AbstractTypeDeclaration declaration = this.getBodyDeclaration();
        return declaration instanceof EnumDeclaration;
    }

    public boolean isInterface() {
        AbstractTypeDeclaration declaration = this.getBodyDeclaration();
        return declaration instanceof TypeDeclaration && ((TypeDeclaration)declaration).isInterface();
    }

    public boolean isAnnotation() {
        AbstractTypeDeclaration declaration = this.getBodyDeclaration();
        return declaration instanceof AnnotationTypeDeclaration;
    }

    public List<String> getInterfaces() {
        ArrayList<String> result = new ArrayList<String>();
        List<Type> superTypes = JDTHelper.getInterfaces((BodyDeclaration)this.getBodyDeclaration());
        for (Type type : superTypes) {
            Import imprt;
            String pkg;
            String name = JDTHelper.getTypeName(type);
            if (Types.isSimpleName((String)name) && this.hasImport(name) && !Strings.isNullOrEmpty((String)(pkg = (imprt = this.getImport(name)).getPackage()))) {
                name = pkg + "." + name;
            }
            result.add(name);
        }
        return result;
    }

    public O addInterface(String type) {
        List<Type> interfaces = JDTHelper.getInterfaces((BodyDeclaration)((JavaInterfaceImpl)JavaParser.parse(JavaInterfaceImpl.class, (String)("public interface Mock extends " + type + " {}"))).getBodyDeclaration());
        if (!interfaces.isEmpty()) {
            if (!this.hasImport(Types.toSimpleName((String)type))) {
                this.addImport(type);
            }
        } else {
            throw new IllegalArgumentException("Could not parse interface declaration [" + type + "]");
        }
        Type t = interfaces.get(0);
        ASTNode node = ASTNode.copySubtree((AST)this.unit.getAST(), (ASTNode)t);
        JDTHelper.getInterfaces((BodyDeclaration)this.getBodyDeclaration()).add((Type)node);
        return (O)this;
    }

    public O addInterface(Class<?> type) {
        return this.addInterface(type.getName());
    }

    public O addInterface(JavaInterface type) {
        return this.addInterface(type.getQualifiedName());
    }

    public boolean hasInterface(String type) {
        for (String name : this.getInterfaces()) {
            if (!Types.areEquivalent((String)name, (String)type)) continue;
            return true;
        }
        return false;
    }

    public boolean hasInterface(Class<?> type) {
        return this.hasInterface(type.getName());
    }

    public boolean hasInterface(JavaInterface type) {
        return this.hasInterface(type.getQualifiedName());
    }

    public O removeInterface(String type) {
        List<Type> interfaces = JDTHelper.getInterfaces((BodyDeclaration)this.getBodyDeclaration());
        for (Type i : interfaces) {
            if (!Types.areEquivalent((String)i.toString(), (String)type)) continue;
            interfaces.remove(i);
            break;
        }
        return (O)this;
    }

    public O removeInterface(Class<?> type) {
        return this.removeInterface(type.getName());
    }

    public O removeInterface(JavaInterface type) {
        return this.removeInterface(type.getQualifiedName());
    }
}

