/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.project.dependencies;

import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.facets.DependencyFacet;

public class DependencyRepositoryImpl
implements DependencyRepository {
    private final String id;
    private final String url;

    public DependencyRepositoryImpl(String id, String url) {
        if (Strings.isNullOrEmpty((String)id)) {
            throw new IllegalArgumentException("must specify repository id");
        }
        if (Strings.isNullOrEmpty((String)url)) {
            throw new IllegalArgumentException("must specify repository url");
        }
        this.id = id;
        this.url = url;
    }

    public DependencyRepositoryImpl(DependencyFacet.KnownRepository repo) {
        this(repo.getId(), repo.getUrl());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "[id=" + this.id + ", url=" + this.url + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DependencyRepositoryImpl other = (DependencyRepositoryImpl)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.url == null ? other.url != null : !this.url.equals(other.url));
    }
}

