/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.descriptor.spi.node.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.shrinkwrap.descriptor.api.DescriptorImportException;
import org.jboss.shrinkwrap.descriptor.spi.node.Node;
import org.jboss.shrinkwrap.descriptor.spi.node.NodeImporter;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;

public final class XmlDomNodeImporterImpl
implements NodeImporter {
    private final Logger log = Logger.getLogger(XmlDomNodeImporterImpl.class.getName());

    public Node importAsNode(InputStream stream, boolean close) throws DescriptorImportException {
        try {
            if (stream.available() == 0) {
                Node node = null;
                return node;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            Node root = new Node(doc.getDocumentElement().getNodeName());
            this.readRecursive(root, doc.getDocumentElement());
            Node node = root;
            return node;
        }
        catch (Exception e) {
            throw new DescriptorImportException("Could not import XML from stream", (Throwable)e);
        }
        finally {
            if (close) {
                try {
                    stream.close();
                }
                catch (IOException ioe) {
                    try {
                        stream.close();
                    }
                    catch (IOException i) {
                        this.log.log(Level.WARNING, "Unclosable stream specified to be closed: {0}", stream);
                    }
                }
            }
        }
    }

    private void readRecursive(Node target, org.w3c.dom.Node source) {
        this.readAttributes(target, source);
        NodeList sourceChildren = source.getChildNodes();
        if (sourceChildren != null) {
            for (int i = 0; i < sourceChildren.getLength(); ++i) {
                org.w3c.dom.Node child = sourceChildren.item(i);
                if (child.getNodeType() == 3) continue;
                Node newTarget = target.createChild(child.getNodeName());
                if (this.onlyTextChildren(child)) {
                    if (child.getNodeType() == 8) {
                        newTarget.setComment(true);
                    }
                    newTarget.text(child.getTextContent());
                    this.readAttributes(newTarget, child);
                    continue;
                }
                this.readRecursive(newTarget, child);
            }
        }
    }

    private void readAttributes(Node target, org.w3c.dom.Node source) {
        NamedNodeMap attributes = source.getAttributes();
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                org.w3c.dom.Node attribute = attributes.item(i);
                target.attribute(attribute.getNodeName(), attribute.getNodeValue());
            }
        }
    }

    private boolean onlyTextChildren(org.w3c.dom.Node source) {
        NodeList children = source.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            org.w3c.dom.Node child = children.item(i);
            if (child.getNodeType() == 3) continue;
            return false;
        }
        return true;
    }
}

