/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.parser.java.util;

import java.util.Arrays;
import java.util.List;

public class Types {
    static List<String> langTypes = Arrays.asList("Appendable", "AutoCloseable", "CharSequence", "Cloneable", "Comparable", "Iterable", "Readable", "Runnable", "Boolean", "Byte", "Character", "Character.Subset", "Character.UnicodeBlock", "Class", "ClassLoader", "ClassValue", "Compiler", "Double", "Enum", "Float", "InheritableThreadLocal", "Integer", "Long", "Math", "Number", "Object", "Package", "Process", "ProcessBuilder", "ProcessBuilder.Redirect", "Runtime", "RuntimePermission", "SecurityManager", "Short", "StackTraceElement", "StrictMath", "String", "StringBuffer", "StringBuilder", "System", "Thread", "ThreadGroup", "ThreadLocal", "Throwable", "Void", "AbstractMethodError", "AssertionError", "BootstrapMethodError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "AbstractMethodError", "AssertionError", "BootstrapMethodError", "ClassCircularityError", "ClassFormatError", "Error", "ExceptionInInitializerError", "IllegalAccessError", "IncompatibleClassChangeError", "InstantiationError", "InternalError", "LinkageError", "NoClassDefFoundError", "NoSuchFieldError", "NoSuchMethodError", "OutOfMemoryError", "StackOverflowError", "ThreadDeath", "UnknownError", "UnsatisfiedLinkError", "UnsupportedClassVersionError", "VerifyError", "VirtualMachineError", "Deprecated", "Override", "SafeVarargs", "SuppressWarnings");

    public static boolean areEquivalent(String left, String right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left.equals(right)) {
            return true;
        }
        left = Types.stripGenerics(left);
        right = Types.stripGenerics(right);
        String l = Types.toSimpleName(left);
        String r = Types.toSimpleName(right);
        String lp = Types.getPackage(left);
        String rp = Types.getPackage(right);
        if (l.equals(r)) {
            return lp.isEmpty() || rp.isEmpty();
        }
        return false;
    }

    public static String toSimpleName(String fieldType) {
        String[] tokens;
        String result = fieldType;
        if (result != null && (tokens = Types.tokenizeClassName(result)) != null) {
            result = tokens[tokens.length - 1];
        }
        return result;
    }

    public static String[] tokenizeClassName(String className) {
        String[] result = null;
        if (className != null) {
            result = className.split("\\.");
        }
        return result;
    }

    public static boolean isQualified(String className) {
        String[] tokens = Types.tokenizeClassName(className);
        return tokens != null && tokens.length > 1;
    }

    public static String getPackage(String className) {
        if (className.indexOf(".") > -1) {
            return className.substring(0, className.lastIndexOf("."));
        }
        return "";
    }

    public static boolean isSimpleName(String name) {
        return name != null && name.matches("(?i)(?![0-9])[a-z0-9$_]+");
    }

    public static boolean isJavaLang(String type) {
        for (String t : langTypes) {
            if (!type.endsWith(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBasicType(String idType) {
        return Types.isPrimitive(idType) || Arrays.asList("Boolean", "Byte", "Double", "Float", "Integer", "Long", "Short", "String").contains(idType);
    }

    public static boolean isGeneric(String type) {
        return type != null && type.matches(".*<.*>$");
    }

    public static String stripGenerics(String type) {
        if (Types.isGeneric(type)) {
            return type.replaceFirst("^([^<]*)<.*>$", "$1");
        }
        return type;
    }

    public static String getGenerics(String type) {
        if (Types.isGeneric(type)) {
            return type.replaceFirst("^[^<]*(<.*>)$", "$1");
        }
        return "";
    }

    public static boolean isArray(String type) {
        return type != null && type.matches(".*\\[.*\\]$");
    }

    public static String stripArray(String type) {
        if (Types.isArray(type)) {
            return type.replaceFirst("^([^\\[]*)\\[.*\\]$", "$1");
        }
        return type;
    }

    public static boolean isPrimitive(String result) {
        return Arrays.asList("byte", "short", "int", "long", "float", "double", "boolean", "char").contains(result);
    }
}

