/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.workbench;

import java.util.ArrayList;
import java.util.List;
import java.util.Observable;

public abstract class TableModelList
extends Observable {
    protected final List<Object> filters;

    public TableModelList() {
        this(new ArrayList<Object>());
    }

    public TableModelList(List<Object> queryParameterList) {
        this.filters = queryParameterList;
    }

    public void moveUp(Object tf) {
        this.move(tf, -1);
    }

    private void move(Object tf, int shift) {
        int i = this.filters.indexOf(tf);
        if (i >= 0 && i + shift < this.filters.size() && i + shift >= 0) {
            this.filters.remove(i);
            this.filters.add(i + shift, tf);
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void moveDown(Object tf) {
        this.move(tf, 1);
    }

    protected void add(Object tf) {
        this.filters.add(tf);
        this.setChanged();
        this.notifyObservers();
    }

    protected void remove(Object tf) {
        this.filters.remove(tf);
        this.setChanged();
        this.notifyObservers();
    }

    public List<Object> getList() {
        return this.filters;
    }
}

