/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.utils.DriverClassHelpers;

public class NewConfigurationWizardPage
extends WizardPage {
    private final DriverClassHelpers helper = new DriverClassHelpers();
    private Label containerText;
    private Label fileText;
    private Text sessionFactoryNameText;
    private Combo dialectCombo;
    private Combo driver_classCombo;
    private Text usernameText;
    private Text passwordText;
    private Text defaultSchemaText;
    private Text defaultCatalogText;
    private Combo urlCombo;
    private Button createConsoleConfiguration;
    private ISelection selection;
    private final WizardNewFileCreationPage fileCreation;
    private boolean beenShown = false;

    public NewConfigurationWizardPage(ISelection selection, WizardNewFileCreationPage page) {
        super("wizardPage");
        this.fileCreation = page;
        this.setTitle(HibernateConsoleMessages.NewConfigurationWizardPage_hibernate_config_file);
        this.setDescription(HibernateConsoleMessages.NewConfigurationWizardPage_this_wizard_creates);
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewConfigurationWizardPage.this.dialogChanged();
            }
        };
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NewConfigurationWizardPage.this.dialogChanged();
                NewConfigurationWizardPage.this.getContainer().updateButtons();
            }

            public void widgetSelected(SelectionEvent e) {
                NewConfigurationWizardPage.this.dialogChanged();
                NewConfigurationWizardPage.this.getContainer().updateButtons();
            }
        };
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        Label label = new Label(container, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_container);
        this.containerText = new Label(container, 2052);
        GridData gd = new GridData(768);
        this.containerText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_file_name);
        this.fileText = new Label(container, 2052);
        gd = new GridData(768);
        this.fileText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_session_factory_name);
        this.sessionFactoryNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.sessionFactoryNameText.setLayoutData((Object)gd);
        this.sessionFactoryNameText.addModifyListener(listener);
        label = new Label(container, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_database_dialect);
        this.dialectCombo = new Combo(container, 0);
        this.fillHerUp(this.dialectCombo, this.helper.getDialectNames());
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.dialectCombo.setLayoutData((Object)gd);
        this.dialectCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] driverClasses = NewConfigurationWizardPage.this.helper.getDriverClasses(NewConfigurationWizardPage.this.helper.getDialectClass(NewConfigurationWizardPage.this.dialectCombo.getText()));
                NewConfigurationWizardPage.this.fillHerUp(NewConfigurationWizardPage.this.driver_classCombo, driverClasses);
                NewConfigurationWizardPage.this.dialogChanged();
            }
        });
        gd = new GridData(1, 2, false, false);
        gd.horizontalAlignment = 128;
        gd.verticalAlignment = 128;
        label.setLayoutData((Object)gd);
        Composite driverManagerTabContainer = container;
        label = new Label(driverManagerTabContainer, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_driver_class);
        this.driver_classCombo = new Combo(driverManagerTabContainer, 0);
        this.driver_classCombo.select(0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.driver_classCombo.setLayoutData((Object)gd);
        this.driver_classCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String[] connectionURLS = NewConfigurationWizardPage.this.helper.getConnectionURLS(NewConfigurationWizardPage.this.driver_classCombo.getText());
                NewConfigurationWizardPage.this.fillHerUp(NewConfigurationWizardPage.this.urlCombo, connectionURLS);
                NewConfigurationWizardPage.this.dialogChanged();
            }
        });
        label = new Label(driverManagerTabContainer, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_connection_url);
        this.urlCombo = new Combo(driverManagerTabContainer, 0);
        this.urlCombo.select(0);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.urlCombo.setLayoutData((Object)gd);
        this.urlCombo.addModifyListener(listener);
        label = new Label(driverManagerTabContainer, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_default_schema);
        this.defaultSchemaText = new Text(driverManagerTabContainer, 2052);
        gd = new GridData(768);
        this.defaultSchemaText.setLayoutData((Object)gd);
        this.defaultSchemaText.addModifyListener(listener);
        label = new Label(driverManagerTabContainer, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_default_catalog);
        this.defaultCatalogText = new Text(driverManagerTabContainer, 2052);
        gd = new GridData(768);
        this.defaultCatalogText.setLayoutData((Object)gd);
        this.defaultCatalogText.addModifyListener(listener);
        label = new Label(driverManagerTabContainer, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_user_name);
        this.usernameText = new Text(driverManagerTabContainer, 2052);
        gd = new GridData(768);
        this.usernameText.setLayoutData((Object)gd);
        this.usernameText.addModifyListener(listener);
        label = new Label(driverManagerTabContainer, 0);
        label.setText(HibernateConsoleMessages.NewConfigurationWizardPage_password);
        this.passwordText = new Text(driverManagerTabContainer, 2052);
        gd = new GridData(768);
        this.passwordText.setLayoutData((Object)gd);
        this.passwordText.addModifyListener(listener);
        this.fillLabel(container);
        this.fillLabel(container);
        this.fillLabel(container);
        this.createConsoleConfiguration = new Button(container, 32);
        gd = new GridData(768);
        this.createConsoleConfiguration.setLayoutData((Object)gd);
        this.createConsoleConfiguration.setText(HibernateConsoleMessages.NewConfigurationWizardPage_create_console_configuration);
        this.createConsoleConfiguration.addSelectionListener(selectionListener);
        sc.setMinSize(container.computeSize(-1, -1));
        this.initialize();
        this.dialogChanged();
        this.setControl((Control)sc);
    }

    private void fillHerUp(Combo combo, String[] newContent) {
        String original = combo.getText();
        combo.removeAll();
        int i = 0;
        while (i < newContent.length) {
            String name = newContent[i];
            combo.add(name);
            ++i;
        }
        combo.setText(original);
    }

    private void fillLabel(Composite container) {
        new Label(container, 0);
    }

    private void initialize() {
        this.updateStatus(null);
    }

    private void dialogChanged() {
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(this.getContainerName()));
        String fileName = this.getFileName();
        if (this.getContainerName().length() == 0) {
            this.updateStatus(HibernateConsoleMessages.NewConfigurationWizardPage_file_container_must_be_specified);
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            this.updateStatus(HibernateConsoleMessages.NewConfigurationWizardPage_file_container_must_exist);
            return;
        }
        if (!container.isAccessible()) {
            this.updateStatus(HibernateConsoleMessages.NewConfigurationWizardPage_project_must_be_writable);
            return;
        }
        if (fileName.length() == 0) {
            this.updateStatus(HibernateConsoleMessages.NewConfigurationWizardPage_file_name_must_be_specified);
            return;
        }
        if (fileName.replace('\\', '/').indexOf(47, 1) > 0) {
            this.updateStatus(HibernateConsoleMessages.NewConfigurationWizardPage_file_name_must_be_valid);
            return;
        }
        this.updateStatus(null);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.setPageComplete(message == null && this.beenShown);
    }

    private String getContainerName() {
        return this.containerText.getText();
    }

    private String getFileName() {
        return this.fileText.getText();
    }

    public String getSessionFactoryName() {
        return this.nullIfEmpty(this.sessionFactoryNameText.getText());
    }

    private String nullIfEmpty(String text) {
        if (text != null && text.trim().length() > 0) {
            return text.trim();
        }
        return null;
    }

    public String getDialect() {
        return this.nullIfEmpty(this.helper.getDialectClass(this.dialectCombo.getText()));
    }

    public String getDriver() {
        return this.nullIfEmpty(this.driver_classCombo.getText());
    }

    public String getConnectionURL() {
        return this.nullIfEmpty(this.urlCombo.getText());
    }

    public String getUsername() {
        return this.nullIfEmpty(this.usernameText.getText());
    }

    public String getPassword() {
        return this.nullIfEmpty(this.passwordText.getText());
    }

    public void setVisible(boolean visible) {
        this.containerText.setText(this.fileCreation.getContainerFullPath().toPortableString());
        this.fileText.setText(this.fileCreation.getFileName());
        super.setVisible(visible);
        if (visible) {
            this.sessionFactoryNameText.setFocus();
        }
        this.beenShown = true;
        this.dialogChanged();
    }

    public boolean isCreateConsoleConfigurationEnabled() {
        return this.createConsoleConfiguration.getSelection();
    }

    public void setCreateConsoleConfigurationVisible(boolean isVisible) {
        if (this.createConsoleConfiguration != null) {
            this.createConsoleConfiguration.setVisible(isVisible);
        }
    }

    public String getDefaultCatalog() {
        return this.nullIfEmpty(this.defaultCatalogText.getText());
    }

    public String getDefaultSchema() {
        return this.nullIfEmpty(this.defaultSchemaText.getText());
    }
}

