/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views.properties;

import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.hibernate.Session;
import org.hibernate.console.QueryPage;
import org.hibernate.eclipse.console.ext.ConsoleExtension;
import org.hibernate.eclipse.console.ext.ConsoleExtensionManager;
import org.hibernate.eclipse.console.views.QueryPageTabView;
import org.hibernate.eclipse.console.views.properties.QueryPagePropertySource;
import org.hibernate.proxy.HibernateProxyHelper;

public class HibernatePropertySourceProvider
implements IPropertySourceProvider {
    private final QueryPageTabView view;

    public HibernatePropertySourceProvider(QueryPageTabView view) {
        this.view = view;
    }

    public IPropertySource getPropertySource(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof QueryPage) {
            return new QueryPagePropertySource((QueryPage)object);
        }
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        QueryPage selectedQueryPage = this.view.getSelectedQueryPage();
        ConsoleExtension consoleExtension = ConsoleExtensionManager.getConsoleExtension(selectedQueryPage.getHibernateExtension());
        return consoleExtension.getPropertySource(object, selectedQueryPage);
    }

    private boolean hasMetaData(Object object, Session currentSession) {
        return currentSession.getSessionFactory().getClassMetadata(HibernateProxyHelper.getClassWithoutInitializingProxy((Object)object)) != null;
    }
}

