/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.console.views;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.actions.AddConfigurationAction;
import org.hibernate.eclipse.console.actions.CloseConfigAction;
import org.hibernate.eclipse.console.actions.CriteriaEditorAction;
import org.hibernate.eclipse.console.actions.DeleteConfigurationAction;
import org.hibernate.eclipse.console.actions.EditConsoleConfiguration;
import org.hibernate.eclipse.console.actions.HQLScratchpadAction;
import org.hibernate.eclipse.console.actions.OpenMappingAction;
import org.hibernate.eclipse.console.actions.OpenSourceAction;
import org.hibernate.eclipse.console.actions.RefreshAction;
import org.hibernate.eclipse.console.views.ReloadConfigurationAction;
import org.hibernate.eclipse.console.views.SchemaExportAction;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;

public class ConfigurationsViewActionGroup
extends ActionGroup {
    public static final String GROUP_PRIMAL_EDITORS = "group.primalEditors";
    public static final String GROUP_PRIMAL_EDITORS_LAST = "group.primalEditors.last";
    public static final String GROUP_CONSOLE_CONFIG = "group.consoleConfig";
    public static final String GROUP_CONSOLE_CONFIG_LAST = "group.consoleConfig.last";
    public static final String GROUP_ADDITION = "group.addition";
    public static final String GROUP_ADDITION_LAST = "group.addition.last";
    public static final String GROUP_OTHER_EDITORS = "group.otherEditors";
    public static final String GROUP_OTHER_EDITORS_LAST = "group.otherEditors.last";
    private Action addConfigurationAction;
    private SelectionListenerAction closeConfigAction;
    private SelectionListenerAction deleteConfigurationAction;
    private SelectionListenerAction refreshAction;
    private SelectionListenerAction reloadConfigurationAction;
    private SelectionListenerAction schemaExportAction;
    private EditConsoleConfiguration editConfigurationAction;
    private final StructuredViewer selectionProvider;
    private SelectionListenerAction hqlEditorAction;
    private CriteriaEditorAction criteriaEditorAction;
    private SelectionListenerAction openMappingAction;
    private SelectionListenerAction openSourceAction;

    public ConfigurationsViewActionGroup(IViewPart part, StructuredViewer selectionProvider) {
        this.selectionProvider = selectionProvider;
        this.addConfigurationAction = new AddConfigurationAction(part);
        this.closeConfigAction = new CloseConfigAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.closeConfigAction);
        this.deleteConfigurationAction = new DeleteConfigurationAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteConfigurationAction);
        IActionBars actionBars = part.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteConfigurationAction);
        this.refreshAction = new RefreshAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
        this.reloadConfigurationAction = new ReloadConfigurationAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.reloadConfigurationAction);
        this.schemaExportAction = new SchemaExportAction(selectionProvider);
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.schemaExportAction);
        this.editConfigurationAction = new EditConsoleConfiguration();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.editConfigurationAction);
        this.hqlEditorAction = new HQLScratchpadAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.hqlEditorAction);
        this.criteriaEditorAction = new CriteriaEditorAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.criteriaEditorAction);
        this.openMappingAction = new OpenMappingAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openMappingAction);
        this.openSourceAction = new OpenSourceAction();
        selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.openSourceAction);
    }

    public void dispose() {
        super.dispose();
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.closeConfigAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteConfigurationAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.reloadConfigurationAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.schemaExportAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.editConfigurationAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.hqlEditorAction);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.criteriaEditorAction);
    }

    public void fillContextMenu(IMenuManager menu) {
        if (this.getContext() == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection == null) {
            return;
        }
        Object first = selection.getFirstElement();
        menu.add((IContributionItem)new Separator(GROUP_PRIMAL_EDITORS));
        menu.appendToGroup(GROUP_PRIMAL_EDITORS, (IAction)this.hqlEditorAction);
        menu.appendToGroup(GROUP_PRIMAL_EDITORS, (IAction)this.criteriaEditorAction);
        menu.add((IContributionItem)new GroupMarker(GROUP_PRIMAL_EDITORS_LAST));
        menu.add((IContributionItem)new Separator(GROUP_CONSOLE_CONFIG));
        menu.appendToGroup(GROUP_CONSOLE_CONFIG, (IAction)this.addConfigurationAction);
        if (first instanceof ConsoleConfiguration) {
            menu.appendToGroup(GROUP_CONSOLE_CONFIG, (IAction)this.reloadConfigurationAction);
            menu.appendToGroup(GROUP_CONSOLE_CONFIG, (IAction)this.editConfigurationAction);
            menu.appendToGroup(GROUP_CONSOLE_CONFIG, (IAction)this.closeConfigAction);
            menu.appendToGroup(GROUP_CONSOLE_CONFIG, (IAction)this.deleteConfigurationAction);
        }
        menu.add((IContributionItem)new GroupMarker(GROUP_CONSOLE_CONFIG_LAST));
        menu.add((IContributionItem)new Separator(GROUP_ADDITION));
        menu.appendToGroup(GROUP_ADDITION, (IAction)this.refreshAction);
        if (first instanceof ConsoleConfiguration) {
            menu.appendToGroup(GROUP_ADDITION, (IAction)this.schemaExportAction);
        }
        menu.add((IContributionItem)new GroupMarker(GROUP_ADDITION_LAST));
        menu.add((IContributionItem)new Separator(GROUP_OTHER_EDITORS));
        if (first != null && (first instanceof PersistentClass || first.getClass() == Property.class)) {
            menu.appendToGroup(GROUP_OTHER_EDITORS, (IAction)this.openSourceAction);
            menu.appendToGroup(GROUP_OTHER_EDITORS, (IAction)this.openMappingAction);
        }
        menu.add((IContributionItem)new GroupMarker(GROUP_OTHER_EDITORS_LAST));
    }

    public void fillActionBars(IActionBars actionBars) {
        actionBars.getToolBarManager().add((IAction)this.reloadConfigurationAction);
        actionBars.getToolBarManager().add((IAction)this.addConfigurationAction);
        actionBars.getToolBarManager().add((IAction)this.hqlEditorAction);
        actionBars.getToolBarManager().add((IAction)this.criteriaEditorAction);
    }
}

