/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.hibernate.console.ConsoleMessages;

public class StringListDialog
extends Dialog {
    private ListViewer listViewer;
    private String[] values;
    private Button buttonAdd;
    private Button buttonRemove;
    private Button buttonModify;

    public StringListDialog(Shell parentShell, String[] initValue) {
        super(parentShell);
        this.values = initValue;
    }

    protected Control createDialogArea(Composite container) {
        Composite parent = (Composite)super.createDialogArea(container);
        this.listViewer = new ListViewer(parent);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(15);
        gd.widthHint = this.convertWidthInCharsToPixels(55);
        List list = this.listViewer.getList();
        list.setLayoutData((Object)gd);
        list.setFont(container.getFont());
        if (this.values != null) {
            list.setItems(this.values);
        }
        if (list.getItemCount() > 0) {
            list.select(list.getItemCount() - 1);
        }
        this.addButtons(parent);
        return parent;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ConsoleMessages.StringListDialog_Elements);
    }

    private void addButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout fillLayout = new FillLayout(256);
        fillLayout.spacing = 2;
        composite.setLayout((Layout)fillLayout);
        this.buttonAdd = new Button(composite, 8);
        this.buttonAdd.setText(ConsoleMessages.StringListDialog_Add);
        this.buttonModify = new Button(composite, 8);
        this.buttonModify.setText(ConsoleMessages.StringListDialog_Modify);
        this.buttonRemove = new Button(composite, 8);
        this.buttonRemove.setText(ConsoleMessages.StringListDialog_Remove);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDialog = new InputDialog(null, ConsoleMessages.StringListDialog_Add_Element, ConsoleMessages.StringListDialog_New_Element, "", null);
                if (inputDialog.open() == 0) {
                    StringListDialog.this.listViewer.getList().add(inputDialog.getValue());
                }
            }
        });
        this.buttonModify.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDialog;
                int line = StringListDialog.this.listViewer.getList().getSelectionIndex();
                if (line >= 0 && (inputDialog = new InputDialog(null, ConsoleMessages.StringListDialog_Modify_Element, ConsoleMessages.StringListDialog_New_Element, StringListDialog.this.listViewer.getList().getItem(line), null)).open() == 0) {
                    StringListDialog.this.listViewer.getList().setItem(line, inputDialog.getValue());
                }
            }
        });
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int line = StringListDialog.this.listViewer.getList().getSelectionIndex();
                if (line < 0) {
                    return;
                }
                StringListDialog.this.listViewer.getList().remove(line);
            }
        });
    }

    protected void okPressed() {
        this.values = this.listViewer.getList().getItems();
        super.okPressed();
    }

    public String[] getValue() {
        return this.values;
    }
}

