/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.view;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.resolver.DialectFactory;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.jboss.tools.hibernate.ui.view.OrmImageMap;
import org.jboss.tools.hibernate.ui.view.OrmLabelMap;

public class OrmLabelProvider
extends LabelProvider
implements IColorProvider,
IFontProvider {
    private Map<ImageDescriptor, Image> imageCache = new HashMap<ImageDescriptor, Image>(25);
    protected String consoleConfigName;
    protected Mapping mapping = null;
    protected Dialect dialect = null;

    public OrmLabelProvider() {
    }

    public OrmLabelProvider(String consoleConfigName) {
        this.setConsoleConfigName(consoleConfigName);
    }

    public void setConsoleConfigName(String consoleConfigName) {
        if (this.consoleConfigName == consoleConfigName) {
            return;
        }
        this.consoleConfigName = consoleConfigName;
        this.mapping = null;
        this.dialect = null;
    }

    protected Configuration getConfig() {
        ConsoleConfiguration consoleConfig = this.getConsoleConfig();
        if (consoleConfig != null) {
            if (!consoleConfig.hasConfiguration()) {
                try {
                    consoleConfig.build();
                    consoleConfig.buildMappings();
                }
                catch (HibernateException hibernateException) {}
            }
            return consoleConfig.getConfiguration();
        }
        return null;
    }

    protected ConsoleConfiguration getConsoleConfig() {
        KnownConfigurations knownConfigurations = KnownConfigurations.getInstance();
        ConsoleConfiguration consoleConfig = knownConfigurations.find(this.consoleConfigName);
        return consoleConfig;
    }

    public Image getImage(Object element) {
        ImageDescriptor descriptor = OrmImageMap.getImageDescriptor(element, this.getConsoleConfig());
        if (descriptor == null) {
            return null;
        }
        Image image = this.imageCache.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            this.imageCache.put(descriptor, image);
        }
        return image;
    }

    public String getText(Object obj) {
        if (obj instanceof Column) {
            this.updateColumnSqlType((Column)obj);
        }
        return OrmLabelMap.getLabel(obj, this.getConsoleConfig());
    }

    public void dispose() {
        Iterator<Image> i = this.imageCache.values().iterator();
        while (i.hasNext()) {
            i.next().dispose();
        }
        this.imageCache.clear();
    }

    public Color getForeground(Object element) {
        if (element instanceof RootClass) {
            return Display.getCurrent().getSystemColor(6);
        }
        if (element instanceof Property) {
            return Display.getCurrent().getSystemColor(10);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }

    public Font getFont(Object element) {
        return null;
    }

    public boolean updateColumnSqlType(final Column column) {
        String dialectName;
        ConsoleConfiguration consoleConfig;
        String sqlType = column.getSqlType();
        if (sqlType != null) {
            return false;
        }
        final Configuration config = this.getConfig();
        if (this.mapping == null && config != null) {
            consoleConfig = this.getConsoleConfig();
            this.mapping = (Mapping)consoleConfig.execute(new ExecutionContext.Command(){

                public Object execute() {
                    return config.buildMapping();
                }
            });
        }
        if (this.dialect == null && config != null && (dialectName = config.getProperty("hibernate.dialect")) != null) {
            try {
                this.dialect = DialectFactory.buildDialect((Properties)config.getProperties());
            }
            catch (HibernateException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("HibernateException: ", (Throwable)e);
            }
        }
        if (this.dialect != null) {
            consoleConfig = this.getConsoleConfig();
            try {
                sqlType = (String)consoleConfig.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        return column.getSqlType(OrmLabelProvider.this.dialect, OrmLabelProvider.this.mapping);
                    }
                });
            }
            catch (HibernateException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("HibernateException: ", (Throwable)e);
            }
            catch (Exception e) {
                HibernateConsolePlugin.getDefault().logErrorMessage("Exception: ", (Throwable)e);
            }
        }
        if (sqlType != null) {
            column.setSqlType(sqlType);
            return true;
        }
        return false;
    }
}

